select tp.entidade,
       tp.dataparcelamento     as datamovimentacao,
       tr.receita              as tributo,
       tr.descricao            as descricaotributo,
       desconto.classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tp.dataparcelamento )
         then tdp.situacaolegal
         else 0
       end                     situacaolegal,
       ttot.codigotce          as tipooperacaodeducao,
       'DESCONTO_PARCELAMENTO' as tipomovimento,
       sum(desconto.valor)     as valor
from   tribparcelamento tp
       left outer join tribparamparcelamento tpp
                    on tp.idparametroparcelamento = tpp.idparametroparcelamento
       left outer join tribmotivodesconto tmd
                    on tpp.motivodesconto = tmd.motivodesconto
       left outer join tribtipooperacaotce ttot
                    on tmd.idtipooperacaotce = ttot.idtipooperacaotce
       left outer join (select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.receitaorigem      as tributo,
                               tpre.valordescontoprincipal as valor,
                               tpre.iddebitonovo,
                               'P'                     as classificacaotributo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valordescontoprincipal > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.receitaorigem      as tributo,
                               tpre.valordescontojuros as valor,
                               tpre.iddebitonovo,
                               'J'                     as classificacaotributo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valordescontojuros > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.receitaorigem      as tributo,
                               tpre.valordescontomulta as valor,
                               tpre.iddebitonovo,
                               'M'                     as classificacaotributo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valordescontomulta > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.receitaorigem         as tributo,
                               tpre.valordescontocorrecao as valor,
                               tpre.iddebitonovo,
                               'C'                        as classificacaotributo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valordescontocorrecao > 0) desconto
                    on desconto.idparcelamento = tp.idparcelamento
       left outer join tribdebito td
                    on td.iddebito = desconto.iddebitonovo
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = 1
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and td.exercicio = tr.exercicio
                   and desconto.tributo = tr.receita
where  td.constituido = 'S'
  and  coalesce(tr.inscrito, 1) = 1
  and  tp.dataparcelamento in (:datasMovimento)
group  by tp.entidade,
          tp.dataparcelamento,
          tr.receita,
          tr.descricao,
          desconto.classificacaotributo,
          case
            when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tp.dataparcelamento )
            then tdp.situacaolegal
            else 0
          end,
          ttot.codigotce