select
    d.iddebito,
    d.entidade,
    d.exercicio,
    d.tipocadastro,
    d.cadastrogeral,
    d.guiarecolhimento as divida,
    d.subdivida
from tribdebito d
where exists(
    select 1
        from tribpagamentobloqueto pb
        inner join tribpagamento p on p.entidade = pb.entidade
        and p.exerciciopagamento = pb.exerciciopagamento
        and p.pagamento = pb.pagamento
        inner join tribpagamentodebito pd on pd.idpagamentobloqueto = pb.idpagamentobloqueto
        inner join tribdebitoparcelareceita dpr on dpr.iddebitoparcelareceita = pd.iddebitoparcelareceita
        inner join tribdebitoparcela dp on dpr.entidade = dp.entidade
        and dpr.exercicio = dp.exercicio
        and dpr.tipocadastro = dp.tipocadastro
        and dpr.cadastrogeral = dp.cadastrogeral
        and dpr.guiarecolhimento = dp.guiarecolhimento
        and dpr.subdivida = dp.subdivida
        and dpr.parcela = dp.parcela
        where dp.entidade = d.entidade
        and dp.exercicio = d.exercicio
        and dp.tipocadastro = d.tipocadastro
        and dp.cadastrogeral = d.cadastrogeral
        and dp.guiarecolhimento = d.guiarecolhimento
        and dp.subdivida = d.subdivida
        and p.entidade = :entidade
        and p.exerciciopagamento = :exercicioPagamento
        and p.pagamento = :pagamento
    )