SELECT
       $[FILTROTODOSCADASTROS],
	   TD.ENTIDADE,
	   TD.EXERCICIO,
	   TD.TIPOCADASTRO,
	   TD.CADASTROGERAL,
	   TD.GUIARECOLHIMENTO as DIVIDA,
	   CAST(TD.SUBDIVIDA as NUMERIC(15,2)) as SubDivida,
	   TD.IDDEBITO,
	   TDP.PARCELA,
       TSP.DESCRICAO as SITUACAODEBITODESCRICAO,
	   TDPR.RECEITA as TRIBUTO,
	   P.PESSOA,
	   P.NOME as NOMECONTRIBUINTE,
	   P.TIPOPESSOA,
	   P.CNPJ_CPF AS CNPJCPFCONTRIBUINTE,
	   EP.NUMERO as NUMEROCONTRIBUINTE,
	   EP.COMPLEMENTO as COMPLEMENTOCONTRIBUINTE,
       LP.descricao as LOGRADOUROCONTRIBUINTE,
       TLP.DESCRICAO as TIPOLOGRADOUROCONTRIBUINTE,
       CP.DESCRICAO AS CIDADECONTRIBUINTE,
       CP.UNIDADEFEDERACAO as UNIDADEFEDERACAOCONTRIBUINTE,
	   TIPOLOG.DESCRICAO as TIPOLOGRADOURO,
	   LOG.DESCRICAO as LOGRADOURO,
	   TCG.NUMERO as NUMERO,
	   TCG.COMPLEMENTO as COMPLEMENTO,
	   TSP.TipoSituacaoParcela,
	   TDP.SITUACAOLEGAL,
	   TD.DataPrimeiraParcela as DATAPRIMEIRAPARCELA,
	   TD.FormaCorrecao,
	   CASE WHEN TD.Parcelado = 'S' THEN 1 ELSE 0 END AS PARCELADO,
       CASE WHEN TD.Reparcelado = 'S' THEN 1 ELSE 0 END AS REPARCELADO,
       COALESCE(CASE WHEN TTSP.TIPO <> 'A' THEN
                COALESCE(TCDI.VALOR,TDPR.VALOR)
            ELSE
                TDPR.VALOR
           end, 0) as ValorPrincipal,
	   TDP.DATAVENCIMENTO,
	   TDP.DATALANCAMENTO,
	   TDP.DATASITUACAO DATAMOVIMENTO,
       TDP.IDPROTESTO,
	   TP.LOTE,
	   COALESCE(CASE WHEN tsp.tiposituacaoparcela = 2 THEN
	         tpd.valorpago
	   ELSE 0 END, 0) AS VALORPAGO,
	   TGR.DESCRICAO AS DESCRICAODIVIDA,
	   TSP.SIGLA || CASE
	     WHEN TD.PARCELADO = 'S' THEN '.P'
	     WHEN TD.REPARCELADO = 'S' THEN '.R'
	     ELSE ''
	   END || CASE
	     WHEN TDP.SITUACAOLEGAL = 0 THEN '.EX'
	     WHEN TDP.SITUACAOLEGAL = 1 THEN '.DA'
	     WHEN TDP.SITUACAOLEGAL = 2 THEN '.AJ'
	     ELSE ''
	   END || CASE
	     WHEN TDP.IDPROTESTO > 0 THEN '.PR'
	     ELSE ''
	   END as situacaodebitosigla,
	   TP.PAGAMENTO,
	   TP.EXERCICIOPAGAMENTO,
       TD.IDPARCELAMENTO,
       COALESCE(TPD.VALORJUROS, 0) as VALORJUROSPAGAMENTO,
       COALESCE(TPD.VALORMULTA, 0) as VALORMULTAPAGAMENTO,
       COALESCE(TPD.VALORCORRECAO, 0) as VALORCORRECAOPAGAMENTO,
       COALESCE(TPD.VALORDESCONTO, 0) as VALORDESCONTOPAGAMENTO,
       TCI.INSCRICAOCADASTRAL,
       TCI.QUADRICULA_INSCRICAOCADASTRAL as QUADRICULA,
       TCI.DISTRITO_INSCRICAOCADASTRAL as DISTRITO,
       TS.SETOR,
       TSQ.QUADRA,
       TCI.LOTE_INSCRICAOCADASTRAL as LOTEINSCRICAOCADASTRAL,
       TCI.UNIDADE_INSCRICAOCADASTRAL as UNIDADE,
       TCI.COMPLEMENTOLOTE,
       TPA.NUMEROCONTRATO,
       TPA.ANOCONTRATO
  FROM TRIBDEBITOPARCELA TDP
  LEFT OUTER JOIN TRIBDEBITO TD ON TD.ENTIDADE = TDP.ENTIDADE
                               AND TD.EXERCICIO = TDP.EXERCICIO
                               AND TD.TIPOCADASTRO = TDP.TIPOCADASTRO
                               AND TD.CADASTROGERAL = TDP.CADASTROGERAL
                               AND TD.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO
                               AND TD.SUBDIVIDA = TDP.SUBDIVIDA
  LEFT OUTER JOIN TRIBPARCELAMENTO TPA ON TD.IDPARCELAMENTO = TPA.IDPARCELAMENTO
                                      OR TD.IDREPARCELAMENTO = TPA.IDPARCELAMENTO
  LEFT OUTER JOIN TRIBSITUACAOPARCELA TSP ON TSP.SITUACAOPARCELA = TDP.SITUACAODEBITO
  LEFT OUTER JOIN TRIBTIPOSITUACAOPARCELA TTSP ON TTSP.TIPOSITUACAOPARCELA = TSP.TIPOSITUACAOPARCELA
  LEFT OUTER JOIN TRIBGUIARECOLHIMENTO TGR ON TGR.ENTIDADE = TD.ENTIDADE
                                          AND TGR.EXERCICIO = TD.EXERCICIO
                                          AND TGR.GUIARECOLHIMENTO = TD.GUIARECOLHIMENTO
  LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR ON TDP.ENTIDADE = TDPR.ENTIDADE
                                               AND TDP.EXERCICIO = TDPR.EXERCICIO
                                               AND TDP.TIPOCADASTRO = TDPR.TIPOCADASTRO
                                               AND TDP.CADASTROGERAL = TDPR.CADASTROGERAL
                                               AND TDP.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO
                                               AND TDP.SUBDIVIDA = TDPR.SUBDIVIDA
                                               AND TDP.PARCELA = TDPR.PARCELA
  LEFT OUTER JOIN TRIBCANCELAMENTODEBITOITEM TCDI ON TCDI.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
                                                 AND TCDI.ESTORNADO = 'N'
  LEFT OUTER JOIN TRIBPAGAMENTODEBITO TPD ON TPD.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
  LEFT OUTER JOIN TRIBPAGAMENTOBLOQUETO TPB ON TPB.IDPAGAMENTOBLOQUETO = TPD.IDPAGAMENTOBLOQUETO
  LEFT OUTER JOIN TRIBPAGAMENTO TP ON TPB.ENTIDADE = TP.ENTIDADE
                                  AND TPB.EXERCICIOPAGAMENTO = TP.EXERCICIOPAGAMENTO
                                  AND TPB.PAGAMENTO = TP.PAGAMENTO
  LEFT OUTER JOIN TRIBCADASTROGERAL TCG ON TCG.TIPOCADASTRO = TD.TIPOCADASTRO
                                       AND TCG.CADASTROGERAL = TD.CADASTROGERAL
  LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO TCI ON TCG.IDKEY = TCI.TRIBCADASTROGERAL_IDKEY
  LEFT OUTER JOIN TRIBSETOR TS ON TCI.TRIBSETOR_IDKEY = TS.IDKEY
  LEFT OUTER JOIN TRIBSETORQUADRA TSQ ON TCI.TRIBSETOR_IDKEY = TSQ.TRIBSETOR_IDKEY
                          AND TCI.QUADRA_INSCRICAOCADASTRAL = TSQ.QUADRA
  LEFT OUTER JOIN LOGRADOURO LOG ON TCG.LOGRADOURO_IDKEY = LOG.IDKEY
  LEFT OUTER JOIN TIPOLOGRADOURO TIPOLOG ON LOG.TIPOLOGRADOURO = TIPOLOG.TIPOLOGRADOURO
  LEFT OUTER JOIN PESSOA P ON P.PESSOA = TCG.PESSOA
  LEFT OUTER JOIN ENDERECOPESSOA EP ON P.PESSOA = EP.PESSOA AND EP.SEQUENCIA = P.SEQUENCIAENDERECO
  LEFT OUTER JOIN LOGRADOURO LP ON EP.LOGRADOURO_IDKEY = LP.IDKEY
  LEFT OUTER JOIN TIPOLOGRADOURO TLP ON LP.TIPOLOGRADOURO = TLP.TIPOLOGRADOURO
  LEFT OUTER JOIN CIDADE CP ON EP.CIDADE = CP.CIDADE
  WHERE TD.CONSTITUIDO = 'S'
