select item.id as iditemloteimpressao,
  tfp.tipoformapagamento,
  case
    when tfp.tipoformapagamento = 'P'
    then (select min(tdpr.parcela)
            from tribbloquetodebito tbd
            join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tbd.iddebitoparcelareceita
           where tbd.entidade = tb.entidade
             and tbd.exerciciobloqueto = tb.exerciciobloqueto
             and tbd.bloqueto = tb.bloqueto)
    else tb.bloqueto
  end as identificador,
  tb.datavencimento, tb.valorprincipal, tb.valorprincipal - tb.valordesconto as valorliquido, tb.codigobarras, tb.nossonumero, tb.dvnossonumero, cc.carne,
  tc.banco, conta.agencia, tc.codigocedente, tfp.formapagamento,
  tb.campo1, tb.campo2, tb.campo3, tb.campo4, tb.campo5,
  (%s) tributosBoleto
  from calculoloteimpressaoitem item
  join calculocadastro cc            on cc.id = item.idcalculocadastro
  join tribcarnebloqueto tcb         on tcb.entidade = cc.entidade
                                    and  tcb.exercicio = cc.exercicio
                                    and  tcb.carne = cc.carne
  join tribbloqueto tb               on tb.entidade = tcb.entidade
                                    and tb.exerciciobloqueto = tcb.exercicio
                                    and tb.bloqueto = tcb.bloqueto
  join tribformapagamento tfp        on tfp.formapagamento = tb.formapagamento
  join tribmodelobloqueto tmb        on tmb.modelobloqueto = tb.modelobloqueto
  join tribconvenio tc               on tc.entidade = tmb.entidade
                                    and tc.convenio = tmb.convenio
  join contabancaria conta           on conta.entidade = tc.entidade
                                    and conta.contabancaria = tc.contabancaria
 where item.idcalculoloteimpressao = :idcalculoloteimpressao
 order by item.ordem, tfp.ordememissao, identificador