/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.exception.PaginationException;
import javax.sql.DataSource;
import org.springframework.batch.support.DatabaseType;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.support.MetaDataAccessException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SqlUtils {
    private SqlUtils() {
    }

    public static String withPagination(String query, Pageable pageable, DataSource dataSource) {
        try {
            return SqlUtils.withPagination((String)query, (Pageable)pageable, (DatabaseType)DatabaseType.fromMetaData((DataSource)dataSource));
        }
        catch (MetaDataAccessException e) {
            throw new PaginationException("Erro ao extrair os metadados do banco", (Throwable)e);
        }
    }

    public static String withPagination(String query, Pageable pageable, DatabaseType dbType) {
        StringBuilder queryBuilder = new StringBuilder();
        if (DatabaseType.POSTGRES.equals((Object)dbType) || DatabaseType.H2.equals((Object)dbType)) {
            queryBuilder.append(query).append(" LIMIT ").append(pageable.getPageSize()).append(" OFFSET ").append(pageable.getOffset());
        } else if (DatabaseType.ORACLE.equals((Object)dbType)) {
            long fim = pageable.getOffset() + (long)pageable.getPageSize();
            queryBuilder.append("SELECT * FROM (SELECT R.*, ROWNUM AS RN FROM (").append(query).append(String.format(") R WHERE ROWNUM <= %d) v WHERE V.RN > %d", fim, pageable.getOffset()));
        } else {
            return query;
        }
        return queryBuilder.toString();
    }
}

