/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.JobRepository;

public final class BatchUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchUtils.class);
    public static final ExitStatus PROCESSAMENTO_INTERROMPIDO = new ExitStatus(ExitStatus.FAILED.getExitCode(), "Processamento interrompido de forma inesperada. Tente novamente.");

    private BatchUtils() {
    }

    public static void invalidateRunningJobs(JobRepository jobRepository, JobExplorer jobExplorer) {
        jobExplorer.getJobNames().forEach(jobName -> {
            Set runningJobExecutions = jobExplorer.findRunningJobExecutions(jobName);
            LOGGER.info("Foram encontrados {} job executions pendentes para o job {}.", (Object)runningJobExecutions.size(), jobName);
            runningJobExecutions.forEach(jobExecution -> {
                if (BatchStatus.STARTED.equals((Object)jobExecution.getStatus())) {
                    jobExecution.setEndTime(new Date());
                    jobExecution.setStatus(BatchStatus.FAILED);
                    jobExecution.setExitStatus(PROCESSAMENTO_INTERROMPIDO);
                    jobExecution.getStepExecutions().forEach(stepExecution -> {
                        if (BatchStatus.STARTED.equals((Object)stepExecution.getStatus())) {
                            stepExecution.setEndTime(new Date());
                            stepExecution.setStatus(BatchStatus.FAILED);
                            stepExecution.setExitStatus(PROCESSAMENTO_INTERROMPIDO);
                            jobRepository.update(stepExecution);
                        }
                    });
                    LOGGER.info("Setando o job execution {} para FAILED pois ele n\u00e3o foi finalizado anteriormente.", (Object)jobExecution.getId());
                    jobRepository.update(jobExecution);
                }
            });
        });
    }
}

