/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.unico;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.repository.BairroRepository;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.unico.BairroClientUnico;
import br.com.elotech.tributos.util.ConvertToUpperCase;
import br.com.elotech.unico.client.dto.CidadeDTO;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class BairroServiceUnico
extends CrudService<Bairro, Long>
implements BairroService {
    private BairroRepository bairroRepository;
    private BairroClientUnico bairroClientUnico;

    public BairroServiceUnico(BairroRepository bairroRepository, BairroClientUnico bairroClientUnico) {
        this.bairroRepository = bairroRepository;
        this.bairroClientUnico = bairroClientUnico;
    }

    public Optional<Bairro> buscaOuCriaBairro(BairroDTO bairroDTO) {
        if (StringUtils.isBlank((CharSequence)bairroDTO.getDescricao())) {
            return Optional.empty();
        }
        ConvertToUpperCase.convert((Object)bairroDTO);
        if (Objects.nonNull(bairroDTO.getId())) {
            return this.bairroRepository.findByCidadeIdAndBairro(bairroDTO.getIdCidade(), bairroDTO.getId());
        }
        List bairros = this.bairroRepository.findByCidadeIdAndDescricaoIgnoreCase(bairroDTO.getIdCidade(), bairroDTO.getDescricao());
        if (!bairros.isEmpty()) {
            return bairros.stream().min(Comparator.comparing(Bairro::getInativo));
        }
        if (Objects.nonNull(bairroDTO.getIdCidadeUnico())) {
            br.com.elotech.unico.client.dto.BairroDTO novoBairro = new br.com.elotech.unico.client.dto.BairroDTO();
            novoBairro.setDescricao(bairroDTO.getDescricao());
            CidadeDTO cidadeDTO = new CidadeDTO();
            cidadeDTO.setId(bairroDTO.getIdCidadeUnico());
            novoBairro.setCidade(cidadeDTO);
            br.com.elotech.unico.client.dto.BairroDTO novoBairroCriado = this.bairroClientUnico.saveBairro(novoBairro);
            return this.bairroRepository.findByIdunico(novoBairroCriado.getId());
        }
        return Optional.empty();
    }

    public Optional<Bairro> findByBairroAndCidadeEntidadePrincipal(Long codigo) {
        return this.bairroRepository.findByBairroAndCidadeEntidadePrincipal(codigo);
    }

    public Page<Bairro> findAllByCidadeEntidadePrincipal(Pageable page) {
        return this.bairroRepository.findAllByCidadeEntidadePrincipal(page);
    }
}

