/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.tributos.dto.SimamGeracaoDadosDTO;
import br.com.elotech.tributos.service.batch.simam.LancamentoCreditoJobStarter;
import br.com.elotech.tributos.service.simam.SimAmGeracaoDadosService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SimAmGeracaoDadosService {
    private final LancamentoCreditoJobStarter lancamentoCreditoJobStarter;

    public SimAmGeracaoDadosService(LancamentoCreditoJobStarter lancamentoCreditoJobStarter) {
        this.lancamentoCreditoJobStarter = lancamentoCreditoJobStarter;
    }

    public void iniciarTarefa(SimamGeracaoDadosDTO dados) throws Exception {
        LocalDate dataInicial = LocalDate.of(dados.getExercicio().intValue(), dados.getCompetencia().intValue(), 1);
        LocalDate dataFinal = dataInicial.with(TemporalAdjusters.lastDayOfMonth());
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$simam$TipoArquivoSimAm[dados.getTipoArquivo().ordinal()]) {
            case 1: {
                this.lancamentoCreditoJobStarter.startJob(dataInicial, dataFinal);
                break;
            }
            default: {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Tipo de arquivo n\u00e3o implementado");
            }
        }
    }
}

