/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogeomais;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.dto.integracaogeomais.BoletimGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.LogradouroTestadaGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.LogradouroTestadaPostGeomaisDTO;
import br.com.elotech.tributos.service.BoletimLogradouroService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LogradouroTestadaService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.util.EloRequireNonNull;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class LogradouroTestadaElogeoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogradouroTestadaElogeoService.class);
    private final LogradouroTestadaService logradouroTestadaService;
    private final SetorQuadraService setorQuadraService;
    private final BoletimLogradouroService boletimLogradouroService;
    private final SetorService setorService;
    private final DistritoService distritoService;
    private final LogradouroService logradouroService;

    public Page<LogradouroTestadaGeomaisDTO> findAllGeomaisDTO(Pageable page) {
        return this.logradouroTestadaService.findAll(page).map(arg_0 -> this.entityToGeomaisDTO(arg_0));
    }

    public LogradouroTestadaGeomaisDTO findByIdGeomaisDTO(Long idLogradouroTestada) {
        LogradouroTestada logradouroTestada = (LogradouroTestada)this.logradouroTestadaService.findById((Serializable)idLogradouroTestada).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Logradouro Testada com o id '%d'.", idLogradouroTestada)));
        return this.entityToGeomaisDTO(logradouroTestada);
    }

    public Page<LogradouroTestadaGeomaisDTO> findByRsql(String search, Pageable pageable) {
        return this.logradouroTestadaService.findByRsql(search, pageable).map(arg_0 -> this.entityToGeomaisDTO(arg_0));
    }

    private LogradouroTestadaGeomaisDTO entityToGeomaisDTO(LogradouroTestada logradouroTestada) {
        LogradouroTestadaGeomaisDTO logradouroTestadaGeomaisDTO = LogradouroTestadaGeomaisDTO.from((LogradouroTestada)logradouroTestada);
        List boletimGeomaisDTO = this.boletimLogradouroService.findByIdLogradouroTestada(logradouroTestadaGeomaisDTO.getId()).stream().map(BoletimGeomaisDTO::from).collect(Collectors.toList());
        logradouroTestadaGeomaisDTO.setCaracteristicas(boletimGeomaisDTO);
        return logradouroTestadaGeomaisDTO;
    }

    public LogradouroTestadaGeomaisDTO saveGeomaisDTO(LogradouroTestadaPostGeomaisDTO logradouroTestadaPostGeomaisDTO, Boolean novoCadastro, Long idCadastro) {
        log.info("In\u00edcio atualiza\u00e7\u00e3o do Logradouro Testada Id {}, Distrito {}, Setor {}, Quadra {}", new Object[]{logradouroTestadaPostGeomaisDTO.getId(), logradouroTestadaPostGeomaisDTO.getDistrito(), logradouroTestadaPostGeomaisDTO.getSetor(), logradouroTestadaPostGeomaisDTO.getQuadra()});
        if (!novoCadastro.booleanValue() && !logradouroTestadaPostGeomaisDTO.getId().equals(idCadastro)) {
            throw new EloValidationException(String.format("Id da Se\u00e7\u00e3o %d diferente do Request %d.", idCadastro, logradouroTestadaPostGeomaisDTO.getId()));
        }
        LogradouroTestada logradouroTestadaToSave = logradouroTestadaPostGeomaisDTO.toEntity();
        Distrito distrito = (Distrito)this.distritoService.findById((Serializable)((Object)logradouroTestadaPostGeomaisDTO.getDistrito())).orElseThrow(() -> new EloValidationException(String.format("Distrito %s n\u00e3o localizado.", logradouroTestadaPostGeomaisDTO.getDistrito())));
        Setor setor = (Setor)EloRequireNonNull.eloRequireNonNull((Object)this.setorService.findByDistritoDistritoAndSetor(logradouroTestadaPostGeomaisDTO.getDistrito(), logradouroTestadaPostGeomaisDTO.getSetor()), (String)String.format("Setor %s n\u00e3o localizado.", logradouroTestadaPostGeomaisDTO.getSetor()));
        logradouroTestadaToSave.setSetorQuadra((SetorQuadra)EloRequireNonNull.eloRequireNonNull((Object)this.setorQuadraService.findBySetorDistritoDistritoAndSetorSetorAndQuadra(distrito.getDistrito(), setor.getSetor(), logradouroTestadaPostGeomaisDTO.getQuadra()), (String)String.format("Quadra %s n\u00e3o localizada.", logradouroTestadaPostGeomaisDTO.getQuadra())));
        logradouroTestadaToSave.setLogradouro((Logradouro)this.logradouroService.findByLogradouroAndCidadeEntidadePrincipal(logradouroTestadaPostGeomaisDTO.getLogradouro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Logradouro %s n\u00e3o localizado.", logradouroTestadaPostGeomaisDTO.getLogradouro().getCodigo()))));
        LogradouroTestada prepared = this.prepareGeomaisToSave(logradouroTestadaToSave, novoCadastro);
        LogradouroTestada saved = (LogradouroTestada)this.logradouroTestadaService.save((EloEntity)prepared, null);
        this.boletimLogradouroService.merge(logradouroTestadaPostGeomaisDTO.getCaracteristicas(), saved.getId());
        LogradouroTestadaGeomaisDTO logradouroTestadaGeomaisDTO = this.entityToGeomaisDTO(saved);
        log.info("Fim atualiza\u00e7\u00e3o do Logradouro Testada Id {}, Distrito {}, Setor {}, Quadra {}", new Object[]{logradouroTestadaPostGeomaisDTO.getId(), logradouroTestadaPostGeomaisDTO.getDistrito(), logradouroTestadaPostGeomaisDTO.getSetor(), logradouroTestadaPostGeomaisDTO.getQuadra()});
        return logradouroTestadaGeomaisDTO;
    }

    public LogradouroTestada prepareGeomaisToSave(LogradouroTestada logradouroTestadaToSave, Boolean novoCadastro) {
        if (!novoCadastro.booleanValue() && logradouroTestadaToSave.getId() != null) {
            LogradouroTestada logradouroTestadaFound = (LogradouroTestada)this.logradouroTestadaService.findById((Serializable)logradouroTestadaToSave.getId()).orElseThrow(() -> new EloValidationException(String.format("LogradouroTestada %s n\u00e3o encontrado.", logradouroTestadaToSave.getId())));
            return logradouroTestadaFound.mergeGeomais(logradouroTestadaToSave);
        }
        return logradouroTestadaToSave;
    }

    @Generated
    public LogradouroTestadaElogeoService(LogradouroTestadaService logradouroTestadaService, SetorQuadraService setorQuadraService, BoletimLogradouroService boletimLogradouroService, SetorService setorService, DistritoService distritoService, LogradouroService logradouroService) {
        this.logradouroTestadaService = logradouroTestadaService;
        this.setorQuadraService = setorQuadraService;
        this.boletimLogradouroService = boletimLogradouroService;
        this.setorService = setorService;
        this.distritoService = distritoService;
        this.logradouroService = logradouroService;
    }
}

