/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogeomais;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.SituacaoImobiliario;
import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.dto.integracaogeomais.BoletimGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralPostGeomaisDTO;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.BoletimImobiliarioSegmentoService;
import br.com.elotech.tributos.service.BoletimImobiliarioTerrenoService;
import br.com.elotech.tributos.service.BoletimLogradouroService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.CondominioService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.util.EloRequireNonNull;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CadastroImobiliarioElogeoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadastroImobiliarioElogeoService.class);
    private final ParametroGeralService parametroGeralService;
    private final SetorQuadraService setorQuadraService;
    private final BoletimImobiliarioTerrenoService boletimImobiliarioTerrenoService;
    private final BoletimImobiliarioSegmentoService boletimImobiliarioSegmentoService;
    private final BoletimLogradouroService boletimLogradouroService;
    private final DistritoService distritoService;
    private final SetorService setorService;
    private final BairroService bairroService;
    private final LoteamentoService loteamentoService;
    private final CondominioService condominioService;
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final LogradouroService logradouroService;

    public CadastroImobiliarioElogeoService(ParametroGeralService parametroGeralService, SetorQuadraService setorQuadraService, BoletimImobiliarioTerrenoService boletimImobiliarioTerrenoService, BoletimImobiliarioSegmentoService boletimImobiliarioSegmentoService, BoletimLogradouroService boletimLogradouroService, DistritoService distritoService, SetorService setorService, BairroService bairroService, LoteamentoService loteamentoService, CondominioService condominioService, CadastroImobiliarioService cadastroImobiliarioService, LogradouroService logradouroService) {
        this.parametroGeralService = parametroGeralService;
        this.setorQuadraService = setorQuadraService;
        this.boletimImobiliarioTerrenoService = boletimImobiliarioTerrenoService;
        this.boletimImobiliarioSegmentoService = boletimImobiliarioSegmentoService;
        this.boletimLogradouroService = boletimLogradouroService;
        this.distritoService = distritoService;
        this.setorService = setorService;
        this.bairroService = bairroService;
        this.loteamentoService = loteamentoService;
        this.condominioService = condominioService;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.logradouroService = logradouroService;
    }

    public Page<CadastroGeralGeomaisDTO> findAllGeomaisDTO(Pageable page) {
        return this.cadastroImobiliarioService.findAll(page).map(arg_0 -> this.entityToGeomaisDTO(arg_0));
    }

    public CadastroGeralGeomaisDTO findByCadastroGeralGeomaisDTO(Long cadastroGeral) {
        CadastroImobiliario cadastroImobiliario = this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, cadastroGeral);
        if (Objects.isNull(cadastroImobiliario)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar o Cadastro Imobili\u00e1rio com o C\u00f3digo '%d'.", cadastroGeral));
        }
        return this.entityToGeomaisDTO(cadastroImobiliario);
    }

    private CadastroGeralGeomaisDTO entityToGeomaisDTO(CadastroImobiliario cadastroImobiliario) {
        List boletimImobiliarioTerrenos = this.boletimImobiliarioTerrenoService.findByIdCadastroImobiliario(cadastroImobiliario.getId());
        CadastroGeralGeomaisDTO cadastroGeralGeomaisDTO = CadastroGeralGeomaisDTO.from((CadastroImobiliario)cadastroImobiliario, (List)boletimImobiliarioTerrenos);
        cadastroGeralGeomaisDTO.getImobiliario().getSegmentos().forEach(segmentoDTO -> {
            List boletimSegmento = this.boletimImobiliarioSegmentoService.findByIdImobiliarioSegmento(segmentoDTO.getId()).stream().map(BoletimGeomaisDTO::from).collect(Collectors.toList());
            segmentoDTO.setCaracteristicas(boletimSegmento);
        });
        cadastroGeralGeomaisDTO.getImobiliario().getTestadas().forEach(logradouroTestadaDTO -> {
            List boletimLogradouroTestada = this.boletimLogradouroService.findByIdLogradouroTestada(logradouroTestadaDTO.getSecao().getId()).stream().map(BoletimGeomaisDTO::from).collect(Collectors.toList());
            logradouroTestadaDTO.getSecao().setCaracteristicas(boletimLogradouroTestada);
        });
        return cadastroGeralGeomaisDTO;
    }

    public CadastroGeralGeomaisDTO saveGeomaisDTO(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, Boolean novoCadastro, Long cadastroGeral) {
        LOGGER.info("In\u00edcio atualiza\u00e7\u00e3o do Cadastro Geral {}, Tipo Cadastro {}, Id {}", new Object[]{cadastroGeralPostGeomaisDTO.getCodigo(), cadastroGeralPostGeomaisDTO.getTipo(), cadastroGeralPostGeomaisDTO.getId()});
        if (!novoCadastro.booleanValue() && !cadastroGeralPostGeomaisDTO.getCodigo().equals(cadastroGeral)) {
            throw new EloValidationException(String.format("C\u00f3digo do Cadastro %d diferente do Request %d.", cadastroGeral, cadastroGeralPostGeomaisDTO.getCodigo()));
        }
        cadastroGeralPostGeomaisDTO.setCodigo(this.cadastroImobiliarioService.validateAndGetCadastroGeralSequence(cadastroGeralPostGeomaisDTO.getCodigo()));
        CadastroImobiliario cadastroImobiliarioToSave = cadastroGeralPostGeomaisDTO.toEntity();
        cadastroImobiliarioToSave.setDistritoLocalizacao((Distrito)this.distritoService.findById((Serializable)((Object)cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito())).orElseThrow(() -> new EloValidationException(String.format("Distrito %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito()))));
        cadastroImobiliarioToSave.setSetorLocalizacao((Setor)EloRequireNonNull.eloRequireNonNull((Object)this.setorService.findByDistritoDistritoAndSetor(cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor()), (String)String.format("Setor %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getImobiliario().getSetor())));
        cadastroImobiliarioToSave.setQuadraLocalizacao((SetorQuadra)EloRequireNonNull.eloRequireNonNull((Object)this.setorQuadraService.findBySetorDistritoDistritoAndSetorSetorAndQuadra(cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor(), cadastroGeralPostGeomaisDTO.getImobiliario().getQuadra()), (String)String.format("Quadra %s n\u00e3o localizada.", cadastroGeralPostGeomaisDTO.getImobiliario().getQuadra())));
        cadastroImobiliarioToSave.setBairro((Bairro)this.bairroService.findByBairroAndCidadeEntidadePrincipal(cadastroGeralPostGeomaisDTO.getBairro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Bairro %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getBairro().getCodigo()))));
        if (Objects.nonNull(cadastroGeralPostGeomaisDTO.getImobiliario().getCondominio())) {
            cadastroImobiliarioToSave.setCondominio(Optional.ofNullable(this.condominioService.findBySetorDistritoDistritoAndSetorSetorAndCondominio(cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor(), cadastroGeralPostGeomaisDTO.getImobiliario().getCondominio().getCodigo())).orElseThrow(() -> new EloValidationException(String.format("Condom\u00ednio %s do Distrito %s e Setor %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getImobiliario().getCondominio().getCodigo(), cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor()))));
        }
        if (Objects.nonNull(cadastroGeralPostGeomaisDTO.getImobiliario().getLoteamento())) {
            cadastroImobiliarioToSave.setLoteamento(Optional.ofNullable(this.loteamentoService.findBySetorDistritoDistritoAndSetorSetorAndLoteamento(cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor(), cadastroGeralPostGeomaisDTO.getImobiliario().getLoteamento().getCodigo())).orElseThrow(() -> new EloValidationException(String.format("Loteamento %s do Distrito %s e Setor %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getImobiliario().getLoteamento().getCodigo(), cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor()))));
        }
        cadastroGeralPostGeomaisDTO.getProprietarios().stream().map(proprietario -> {
            Pessoa pessoa = (Pessoa)EloRequireNonNull.eloRequireNonNull((Object)((Pessoa)this.cadastroImobiliarioService.getEm().find(Pessoa.class, (Object)proprietario.getPessoa().getId())), (String)String.format("Pessoa %s n\u00e3o localizada.", proprietario.getPessoa().getId()));
            Vinculo vinculo = (Vinculo)EloRequireNonNull.eloRequireNonNull((Object)((Vinculo)this.cadastroImobiliarioService.getEm().find(Vinculo.class, (Object)proprietario.getVinculo().getId())), (String)String.format("V\u00ednculo %s n\u00e3o localizado.", proprietario.getVinculo().getId()));
            return proprietario.toEntity(pessoa, vinculo);
        }).forEach(cadastroImobiliarioToSave.getProprietarios()::add);
        if (Objects.nonNull(cadastroGeralPostGeomaisDTO.getImobiliario().getSegmentos())) {
            cadastroGeralPostGeomaisDTO.getImobiliario().getSegmentos().stream().map(segmento -> {
                TipoSegmento tipoSegmento = (TipoSegmento)EloRequireNonNull.eloRequireNonNull((Object)((TipoSegmento)this.cadastroImobiliarioService.getEm().find(TipoSegmento.class, (Object)segmento.getTipo().getId())), (String)String.format("Tipo de Segmento %s n\u00e3o localizado.", segmento.getTipo().getId()));
                if (Boolean.TRUE.equals(this.cadastroImobiliarioService.utilizaSituacaoSegmento())) {
                    SituacaoSegmentoImob situacaoSegmentoImob = (SituacaoSegmentoImob)EloRequireNonNull.eloRequireNonNull((Object)((SituacaoSegmentoImob)this.cadastroImobiliarioService.getEm().find(SituacaoSegmentoImob.class, (Object)segmento.getSituacao().getId())), (String)String.format("Situa\u00e7\u00e3o de Segmento %s n\u00e3o localizada.", segmento.getSituacao().getId()));
                    return segmento.toEntity(cadastroGeralPostGeomaisDTO.getCodigo(), tipoSegmento, situacaoSegmentoImob);
                }
                return segmento.toEntity(cadastroGeralPostGeomaisDTO.getCodigo(), tipoSegmento);
            }).forEach(cadastroImobiliarioToSave.getSegmentos()::add);
        }
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SITUACAO_IMOBILIARIO).booleanValue() && Objects.nonNull(cadastroGeralPostGeomaisDTO.getImobiliario().getSituacao())) {
            cadastroImobiliarioToSave.setSituacaoImobiliario((SituacaoImobiliario)EloRequireNonNull.eloRequireNonNull((Object)((SituacaoImobiliario)this.cadastroImobiliarioService.getEm().find(SituacaoImobiliario.class, (Object)cadastroGeralPostGeomaisDTO.getImobiliario().getSituacao().getId())), (String)String.format("Situa\u00e7\u00e3o do Imobili\u00e1rio %s n\u00e3o encontrada.", cadastroGeralPostGeomaisDTO.getImobiliario().getSituacao().getId())));
        }
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA).booleanValue()) {
            cadastroGeralPostGeomaisDTO.getImobiliario().getTestadasGenericas().stream().map(testadaGenerica -> {
                Logradouro logradouro = (Logradouro)this.logradouroService.findByLogradouroAndCidadeEntidadePrincipal(testadaGenerica.getLogradouro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Logradouro %s da Testada Gen\u00e9rica n\u00e3o encontrado.", testadaGenerica.getLogradouro().getCodigo())));
                return testadaGenerica.toEntity(logradouro);
            }).forEach(cadastroImobiliarioToSave.getTestadasGenericas()::add);
        } else {
            cadastroGeralPostGeomaisDTO.getImobiliario().getTestadas().stream().map(testada -> {
                LogradouroTestada logradouroTestada = (LogradouroTestada)EloRequireNonNull.eloRequireNonNull((Object)((LogradouroTestada)this.cadastroImobiliarioService.getEm().find(LogradouroTestada.class, (Object)testada.getSecao().getId())), (String)String.format("Se\u00e7\u00e3o %s da Testada n\u00e3o localizada.", testada.getSecao().getId()));
                return testada.toEntity(logradouroTestada);
            }).forEach(cadastroImobiliarioToSave.getTestadas()::add);
        }
        cadastroImobiliarioToSave.validaCamposFiscalizacao();
        CadastroImobiliario prepared = this.prepareGeomaisToSave(cadastroImobiliarioToSave, novoCadastro, cadastroGeralPostGeomaisDTO);
        CadastroImobiliario saved = (CadastroImobiliario)this.cadastroImobiliarioService.save((EloEntity)prepared, null);
        this.boletimImobiliarioTerrenoService.merge(cadastroGeralPostGeomaisDTO.getImobiliario().getBoletim(), saved.getId());
        cadastroGeralPostGeomaisDTO.getImobiliario().getSegmentos().forEach(segmentoDTO -> {
            Long idSegmento = saved.getSegmentos().stream().filter(segmento -> segmento.getSequencia().equals(segmentoDTO.getSequencia())).findFirst().map(CadastroImobiliarioSegmento::getId).get();
            this.boletimImobiliarioSegmentoService.merge(segmentoDTO.getCaracteristicas(), idSegmento.longValue());
        });
        CadastroGeralGeomaisDTO cadastroGeralGeomaisDTO = this.entityToGeomaisDTO(saved);
        LOGGER.info("Fim atualiza\u00e7\u00e3o do Cadastro Geral {}, Tipo Cadastro {}, Id {}", new Object[]{cadastroGeralGeomaisDTO.getCodigo(), cadastroGeralGeomaisDTO.getTipo(), cadastroGeralGeomaisDTO.getId()});
        return cadastroGeralGeomaisDTO;
    }

    private CadastroImobiliario prepareGeomaisToSave(CadastroImobiliario cadastroImobiliarioToSave, Boolean novoCadastro, CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO) {
        if (!novoCadastro.booleanValue() && cadastroImobiliarioToSave.getCadastroGeral() != null) {
            CadastroImobiliario cadastroImobiliarioFound = Optional.ofNullable(this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, cadastroImobiliarioToSave.getCadastroGeral())).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", cadastroImobiliarioToSave.getCadastroGeral())));
            cadastroImobiliarioFound.getSegmentos().forEach(segmento -> {
                if (cadastroGeralPostGeomaisDTO.getImobiliario().getSegmentos().stream().noneMatch(v -> segmento.getSequencia().equals(v.getSequencia()))) {
                    this.boletimImobiliarioSegmentoService.deleteByIdImobiliarioSegmento(segmento.getId());
                }
            });
            return cadastroImobiliarioFound.mergeGeomais(cadastroImobiliarioToSave);
        }
        return cadastroImobiliarioToSave;
    }
}

