/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.TipoOperacaoTce;
import br.com.elotech.tributos.dto.diarioarrecadacao.DiarioArrecadacaoDTO;
import br.com.elotech.tributos.dto.diarioarrecadacao.DiarioArrecadacaoEstornoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.DiarioArrecadacaoConsultaDTO;
import br.com.elotech.tributos.dto.integracaocontabil.DiarioArrecadacaoItemDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroDiarioArrecadacaoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimento;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorDiarioArrecadacaoDTO;
import br.com.elotech.tributos.repository.integracaocontabil.DiarioArrecadacaoRepository;
import br.com.elotech.tributos.service.TipoOperacaoTceService;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DiarioArrecadacaoService {
    private final DiarioArrecadacaoRepository diarioArrecadacaoRepository;
    private final EntidadeServiceImpl entidadeServiceImpl;
    private final TipoOperacaoTceService tipoOperacaoTceService;

    public DiarioArrecadacaoService(DiarioArrecadacaoRepository diarioArrecadacaoRepository, EntidadeServiceImpl entidadeServiceImpl, TipoOperacaoTceService tipoOperacaoTceService) {
        this.diarioArrecadacaoRepository = diarioArrecadacaoRepository;
        this.entidadeServiceImpl = entidadeServiceImpl;
        this.tipoOperacaoTceService = tipoOperacaoTceService;
    }

    public List<DiarioArrecadacaoDTO> findAllDiariosArrecadacao(Long idEntidade, LocalDate dataInicial, LocalDate dataFinal) {
        Entidade entidade = this.findEntidade(idEntidade);
        this.verifyUnidadeFederacaoPermitida(entidade.getUnidadeFederacao());
        TipoOperacaoTce tipoOperacaoTcePadrao = this.tipoOperacaoTceService.findTipoOperacaoTcePadrao(entidade.getUnidadeFederacao());
        FiltroDiarioArrecadacaoDTO filtroDiario = new FiltroDiarioArrecadacaoDTO();
        filtroDiario.setDataArrecadacaoInicial(dataInicial);
        filtroDiario.setDataArrecadacaoFinal(dataFinal);
        filtroDiario.setSituacaoIntegracaoContabil(SituacaoIntegracaoContabil.CONTABILIZADO);
        return this.diarioArrecadacaoRepository.findAllDiariosArrecadacao(filtroDiario, entidade.getId()).stream().map(consultaDTO -> consultaDTO.toDiarioArrecadacaoDTO(tipoOperacaoTcePadrao)).collect(Collectors.toList());
    }

    public List<DiarioArrecadacaoEstornoDTO> findAllDiariosArrecadacaoEstornos(Long idEntidade, LocalDate dataInicial, LocalDate dataFinal) {
        Entidade entidade = this.findEntidade(idEntidade);
        this.verifyUnidadeFederacaoPermitida(entidade.getUnidadeFederacao());
        FiltroDiarioArrecadacaoDTO filtroDiario = new FiltroDiarioArrecadacaoDTO();
        filtroDiario.setDataArrecadacaoInicial(dataInicial);
        filtroDiario.setDataArrecadacaoFinal(dataFinal);
        filtroDiario.getTiposMovimento().addAll(Arrays.asList(TipoMovimento.ESTORNO_PAGAMENTO, TipoMovimento.ESTORNO_CREDITO));
        filtroDiario.setSituacaoIntegracaoContabil(SituacaoIntegracaoContabil.CONTABILIZADO);
        return this.diarioArrecadacaoRepository.findAllDiariosArrecadacao(filtroDiario, entidade.getId()).stream().map(DiarioArrecadacaoConsultaDTO::toDiarioArrecadacaoEstornoDTO).collect(Collectors.toList());
    }

    public Page<DiarioArrecadacaoItemDTO> findDiariosArrecadacao(FiltroDiarioArrecadacaoDTO filtro, Pageable pageable) {
        Entidade entidade = this.getEntidadePrincipal();
        TipoOperacaoTce tipoOperacaoTcePadrao = this.tipoOperacaoTceService.findTipoOperacaoTcePadrao(entidade.getUnidadeFederacao());
        return this.diarioArrecadacaoRepository.findDiariosArrecadacao(filtro, entidade.getId(), pageable).map(consultaDTO -> DiarioArrecadacaoItemDTO.of((DiarioArrecadacaoConsultaDTO)consultaDTO, (TipoOperacaoTce)tipoOperacaoTcePadrao));
    }

    public TotalizadorDiarioArrecadacaoDTO getTotalizador(FiltroDiarioArrecadacaoDTO filtro) {
        Entidade entidade = this.getEntidadePrincipal();
        return this.diarioArrecadacaoRepository.getTotalizador(filtro, entidade.getId());
    }

    private void verifyUnidadeFederacaoPermitida(String uf) {
        String ufParana = "PR";
        if (!"PR".equalsIgnoreCase(uf)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel listar o di\u00e1rio de arrecada\u00e7\u00e3o para unidade de federa\u00e7\u00e3o \"%s\".", uf));
        }
    }

    private Entidade getEntidadePrincipal() {
        Entidade entidade = (Entidade)this.entidadeServiceImpl.getEntidadePrincipal().orElseThrow(() -> new EloValidationException("Entidade principal n\u00e3o encontrada."));
        this.verifyUnidadeFederacaoPermitida(entidade.getUnidadeFederacao());
        return entidade;
    }

    private Entidade findEntidade(Long idEntidade) {
        return (Entidade)this.entidadeServiceImpl.findById((Serializable)idEntidade).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado entidade com id %d.", idEntidade)));
    }
}

