/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.IntegracaoBoletoBBService;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegracaoBoletoService {
    private final IntegracaoBoletoBBService integracaoBoletoBBService;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Bloqueto gerarQrCodePix(Bloqueto bloqueto) {
        Validate.notNull((Object)bloqueto);
        if (Boolean.FALSE.equals(bloqueto.getModeloBloqueto().getConvenio().getUtilizaPix())) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, "Integra\u00e7\u00e3o desabilitada para o conv\u00eanio.");
        }
        if (Objects.nonNull(bloqueto.getCodigoQrCode())) {
            return bloqueto;
        }
        String qrCode = null;
        if (Banco.CODIGO_BANCO_BRASIL.equals(bloqueto.getModeloBloqueto().getConvenio().getBanco().getId())) {
            qrCode = this.integracaoBoletoBBService.gerarQrCodePix(bloqueto);
        }
        if (Objects.nonNull(qrCode)) {
            byte[] imagemQrCode = this.gerarImagemQrCodePix(qrCode);
            bloqueto.setCodigoQrCode(imagemQrCode);
            bloqueto.setTextoQrCode(qrCode);
            return bloqueto;
        }
        throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, "Integra\u00e7\u00e3o n\u00e3o implementada para o banco " + bloqueto.getModeloBloqueto().getConvenio().getBanco().getDescricao());
    }

    private byte[] gerarImagemQrCodePix(String descricao) {
        try {
            HashMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            BitMatrix matrix = new MultiFormatWriter().encode(new String(descricao.getBytes("UTF-8"), "UTF-8"), BarcodeFormat.QR_CODE, 300, 300, hintMap);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"jpg", (OutputStream)out);
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Generated
    public IntegracaoBoletoService(IntegracaoBoletoBBService integracaoBoletoBBService) {
        this.integracaoBoletoBBService = integracaoBoletoBBService;
    }
}

