/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.camposdinamicos.impl;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.domain.camposdinamicos.DynamicValidation;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.camposdinamicos.CampoValidacaoDTO;
import br.com.elotech.tributos.repository.camposdinamicos.CampoRepository;
import br.com.elotech.tributos.repository.camposdinamicos.GrupoCampoRepository;
import br.com.elotech.tributos.service.camposdinamicos.GrupoCampoService;
import br.com.elotech.tributos.service.camposdinamicos.impl.GrupoCampoServiceImpl;
import br.com.elotech.tributos.util.ListUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class GrupoCampoServiceImpl
extends CrudService<GrupoCampo, Long>
implements GrupoCampoService {
    private final GrupoCampoRepository grupoCampoRepository;
    private final CampoRepository campoRepository;

    public GrupoCampoServiceImpl(GrupoCampoRepository grupoCampoRepository, CampoRepository campoRepository) {
        this.grupoCampoRepository = grupoCampoRepository;
        this.campoRepository = campoRepository;
    }

    protected void beforeSave(GrupoCampo grupoCampo, Authentication authentication) {
        grupoCampo.getCampos().forEach(campo -> {
            if (Objects.isNull(campo.getGrupoCampo())) {
                campo.setGrupoCampo(grupoCampo);
            }
        });
        this.validaCadastroCampoDinamico(grupoCampo);
        super.beforeSave((EloEntity)grupoCampo, authentication);
    }

    public List<CampoDetalheDTO> getCampoDetalhesPorFuncionalidade(List<FuncionalidadeCampo> funcionalidadeCampos) {
        return this.campoRepository.getCampoDetalhesPorFuncionalidade(funcionalidadeCampos);
    }

    public List<CampoDetalheDTO> getCamposByFuncionalidade(List<FuncionalidadeCampo> funcionalidadeCampos) {
        return this.campoRepository.getCamposByFuncionalidade(funcionalidadeCampos);
    }

    private void validaCadastroCampoDinamico(GrupoCampo grupoCampo) {
        List campos = this.grupoCampoRepository.findByFuncionalidade(grupoCampo.getFuncionalidade()).stream().map(GrupoCampo::getCampos).flatMap(Collection::stream).filter(campo -> {
            if (Objects.nonNull(grupoCampo.getId())) {
                return !campo.getGrupoCampo().equals((Object)grupoCampo);
            }
            return true;
        }).collect(Collectors.toList());
        campos.addAll(grupoCampo.getCampos());
        List identificadoresDuplicados = ListUtils.findDuplicateItems(campos.stream().map(Campo::getIdentificador).collect(Collectors.toList()));
        if (!identificadoresDuplicados.isEmpty()) {
            throw new EloValidationException(String.format("Existem identificadores duplicados na funcionalidade %s: %s.", grupoCampo.getFuncionalidade().getDescricao(), String.join((CharSequence)", ", identificadoresDuplicados)));
        }
        List camposPossiveis = this.getCamposParaValidacao(grupoCampo.getFuncionalidade());
        ArrayList erros = new ArrayList();
        grupoCampo.getCampos().forEach(campo -> {
            if (TipoCampo.MULTIPLA_ESCOLHA.equals((Object)campo.getTipo()) && campo.getAlternativas().isEmpty()) {
                erros.add(String.format("O campo m\u00faltipla escolha '%s' deve ter ao menos uma alternativa.", campo.getDescricao()));
            }
            campo.getValidacoes().forEach(validacao -> {
                if (camposPossiveis.stream().noneMatch(c -> c.getNome().equalsIgnoreCase(validacao.getCampoDependente()))) {
                    erros.add(String.format("Valida\u00e7\u00e3o do campo '%s' - O campo dependente '%s' n\u00e3o foi localizado.", campo.getDescricao(), validacao.getCampoDependente()));
                }
            });
        });
        if (!erros.isEmpty()) {
            throw new EloValidationException(String.format("Existem inconsist\u00eancias no cadastro de campos:%n%s", String.join((CharSequence)"\n", erros)));
        }
    }

    public List<CampoValidacaoDTO> getCamposParaValidacao(FuncionalidadeCampo funcionalidadeCampo) {
        Stream<CampoValidacaoDTO> camposDinamicos = this.campoRepository.findAllByGrupoFuncionalidade(funcionalidadeCampo).stream().map(CampoValidacaoDTO::from);
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$camposdinamicos$FuncionalidadeCampo[funcionalidadeCampo.ordinal()]) {
            case 1: {
                camposDinamicos = Stream.concat(camposDinamicos, this.getCamposFixos(CadastroImobiliario.class, "Cadastro Imobili\u00e1rio"));
                break;
            }
            case 2: {
                camposDinamicos = Stream.concat(camposDinamicos, this.getCamposFixos(CadastroImobiliario.class, "Cadastro Imobili\u00e1rio"));
                camposDinamicos = Stream.concat(camposDinamicos, this.getCamposFixos(CadastroImobiliarioSegmento.class, "Segmento"));
                break;
            }
            case 3: {
                camposDinamicos = Stream.concat(camposDinamicos, this.getCamposFixos(CadastroMobiliario.class, "Cadastro Mobili\u00e1rio"));
                break;
            }
            case 4: {
                camposDinamicos = Stream.concat(camposDinamicos, this.getCamposFixos(LogradouroTestada.class, "Logradouro Testada"));
            }
        }
        return camposDinamicos.collect(Collectors.toList());
    }

    private Stream<CampoValidacaoDTO> getCamposFixos(Class classToInspect, String name) {
        return Stream.of(classToInspect.getDeclaredFields()).filter(field -> field.isAnnotationPresent(DynamicValidation.class)).map(annotatedField -> {
            DynamicValidation[] annotation = (DynamicValidation[])annotatedField.getAnnotationsByType(DynamicValidation.class);
            CampoValidacaoDTO campoValidacaoDTO = new CampoValidacaoDTO();
            campoValidacaoDTO.setNome(annotatedField.getName());
            campoValidacaoDTO.setDescricao(annotation[0].label());
            campoValidacaoDTO.setDescricaoGrupo(name);
            campoValidacaoDTO.setDinamico(Boolean.FALSE);
            return campoValidacaoDTO;
        });
    }
}

