/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.camposdinamicos;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO;
import br.com.elotech.tributos.repository.camposdinamicos.GrupoCampoRepository;
import br.com.elotech.tributos.repository.camposdinamicos.RespostaRepository;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RespostaService
extends ReadOnlyService<Resposta, Long> {
    private final GrupoCampoRepository grupoCampoRepository;
    private final RespostaRepository respostaRepository;

    public RespostaService(GrupoCampoRepository grupoCampoRepository, RespostaRepository respostaRepository) {
        this.grupoCampoRepository = grupoCampoRepository;
        this.respostaRepository = respostaRepository;
    }

    public void validaRespostas(List<? extends Resposta> lista, FuncionalidadeCampo funcionalidade) {
        List<Resposta> respostas = this.getRespostasAgrupadasVazias(funcionalidade).stream().flatMap(grupoRespostasDTO -> grupoRespostasDTO.getRespostas().stream()).collect(Collectors.toList());
        Map respostasInformadas = lista.stream().collect(Collectors.toMap(resposta -> resposta.getCampo().getIdentificador(), Function.identity(), (resposta1, resposta2) -> resposta1));
        respostas.forEach(resposta -> {
            Resposta respostaInformada = (Resposta)respostasInformadas.get(resposta.getCampo().getIdentificador());
            if (Objects.nonNull(respostaInformada)) {
                resposta.setValor(respostaInformada.getValor());
                resposta.setAlternativa(respostaInformada.getAlternativa());
            }
        });
        respostas.forEach(resposta -> {
            if (Boolean.TRUE.equals(resposta.getCampo().getObrigatorio()) && StringUtils.isBlank((CharSequence)resposta.getValor()) && Objects.isNull(resposta.getAlternativa())) {
                throw new EloValidationException(String.format("O campo '%s' \u00e9 obrigat\u00f3rio", resposta.getCampo().getDescricao()));
            }
            resposta.getCampo().getValidacoes().forEach(validacao -> {
                Resposta respostaParaValidacao = respostas.stream().filter(r -> r.getCampo().getIdentificador().equalsIgnoreCase(validacao.getCampoDependente())).findFirst().orElseThrow(() -> new EloValidationException(String.format("O Campo dependente '%s' n\u00e3o foi localizado.", validacao.getCampoDependente())));
                switch (1.$SwitchMap$br$com$elotech$tributos$domain$camposdinamicos$TipoValidacao[validacao.getTipo().ordinal()]) {
                    case 1: {
                        if (!StringUtils.isBlank((CharSequence)resposta.getValor()) || !Objects.isNull(resposta.getAlternativa()) || StringUtils.isBlank((CharSequence)respostaParaValidacao.getValor()) && !Objects.nonNull(respostaParaValidacao.getAlternativa())) break;
                        throw new EloValidationException(String.format("O campo '%s' deve estar respondido se o campo '%s' estiver.", resposta.getCampo().getDescricao(), respostaParaValidacao.getCampo().getDescricao()));
                    }
                    case 2: {
                        if (!StringUtils.isBlank((CharSequence)resposta.getValor()) || !Objects.isNull(resposta.getAlternativa()) || !StringUtils.isBlank((CharSequence)respostaParaValidacao.getValor()) || !Objects.isNull(respostaParaValidacao.getAlternativa())) break;
                        throw new EloValidationException(String.format("O campo '%s' deve estar respondido se o campo '%s' n\u00e3o estiver.", resposta.getCampo().getDescricao(), respostaParaValidacao.getCampo().getDescricao()));
                    }
                    case 3: {
                        if (StringUtils.isBlank((CharSequence)resposta.getValor()) && !Objects.nonNull(resposta.getAlternativa()) || StringUtils.isBlank((CharSequence)respostaParaValidacao.getValor()) && !Objects.nonNull(respostaParaValidacao.getAlternativa())) break;
                        throw new EloValidationException(String.format("O campo '%s' n\u00e3o deve estar respondido se o campo '%s' estiver.", resposta.getCampo().getDescricao(), respostaParaValidacao.getCampo().getDescricao()));
                    }
                    case 4: {
                        if (StringUtils.isBlank((CharSequence)resposta.getValor()) && !Objects.nonNull(resposta.getAlternativa()) || !StringUtils.isBlank((CharSequence)respostaParaValidacao.getValor()) || !Objects.isNull(respostaParaValidacao.getAlternativa())) break;
                        throw new EloValidationException(String.format("O campo '%s' n\u00e3o deve estar respondido se o campo '%s' n\u00e3o estiver.", resposta.getCampo().getDescricao(), respostaParaValidacao.getCampo().getDescricao()));
                    }
                    case 5: {
                        if (!StringUtils.isBlank((CharSequence)resposta.getValor()) || !Objects.isNull(resposta.getAlternativa()) || (StringUtils.isBlank((CharSequence)respostaParaValidacao.getValor()) || !validacao.getValor().equalsIgnoreCase(respostaParaValidacao.getValor())) && (!Objects.nonNull(respostaParaValidacao.getAlternativa()) || !validacao.getValor().equalsIgnoreCase(respostaParaValidacao.getAlternativa().getCodigo().toString()))) break;
                        throw new EloValidationException(String.format("O campo '%s' \u00e9 obrigat\u00f3rio se o campo '%s' for igual a '%s'.", resposta.getCampo().getDescricao(), respostaParaValidacao.getCampo().getDescricao(), validacao.getValor()));
                    }
                    case 6: {
                        if (StringUtils.isBlank((CharSequence)resposta.getValor()) && !Objects.nonNull(resposta.getAlternativa()) || (StringUtils.isBlank((CharSequence)respostaParaValidacao.getValor()) || !validacao.getValor().equalsIgnoreCase(respostaParaValidacao.getValor())) && (!Objects.nonNull(respostaParaValidacao.getAlternativa()) || !validacao.getValor().equalsIgnoreCase(respostaParaValidacao.getAlternativa().getCodigo().toString()))) break;
                        throw new EloValidationException(String.format("O campo '%s' \u00e9 proibido se o campo '%s' for igual a '%s'.", resposta.getCampo().getDescricao(), respostaParaValidacao.getCampo().getDescricao(), validacao.getValor()));
                    }
                }
            });
        });
    }

    public List<GrupoRespostasDTO> getRespostasAgrupadasVazias(FuncionalidadeCampo funcionalidade) {
        List grupos = this.grupoCampoRepository.findByFuncionalidade(funcionalidade);
        return grupos.stream().map(GrupoRespostasDTO::from).collect(Collectors.toList());
    }

    public List<GrupoRespostasDTO> getRespostasAgrupadas(FuncionalidadeCampo funcionalidade, Long referencia) {
        List todasRespostas;
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$camposdinamicos$FuncionalidadeCampo[funcionalidade.ordinal()]) {
            case 1: {
                todasRespostas = this.respostaRepository.getRespostasFromTerreno(referencia);
                break;
            }
            case 2: {
                todasRespostas = this.respostaRepository.getRespostasFromSegmento(referencia);
                break;
            }
            case 3: {
                todasRespostas = this.respostaRepository.getRespostasFromLogradouro(referencia);
                break;
            }
            case 4: {
                todasRespostas = this.respostaRepository.getRespostasFromAvulso(referencia);
                break;
            }
            case 5: {
                todasRespostas = this.respostaRepository.getRespostasFromMobiliario(referencia);
                break;
            }
            case 6: {
                todasRespostas = this.respostaRepository.getRespostasFromRural(referencia);
                break;
            }
            default: {
                todasRespostas = new ArrayList();
            }
        }
        ArrayList<GrupoRespostasDTO> respostasAgrupadas = new ArrayList<GrupoRespostasDTO>();
        todasRespostas.stream().collect(Collectors.groupingBy(RespostaDTO::getGrupoCampo)).forEach((grupoCampo, respostaDTOS) -> respostasAgrupadas.add(GrupoRespostasDTO.from((GrupoCampo)grupoCampo, (List)respostaDTOS)));
        return respostasAgrupadas;
    }
}

