/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CalculoGeracaoCarneJobStarter {
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job calculoGeracaoCarneBatchJob;

    public CalculoGeracaoCarneJobStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, @Qualifier(value="calculoGeracaoCarneBatchJob") Job calculoGeracaoCarneBatchJob) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.calculoGeracaoCarneBatchJob = calculoGeracaoCarneBatchJob;
    }

    public JobExecution startJob(Long idCalculo) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.CALCULO_GERACAO_CARNE.getTipo()).stream().anyMatch(jobExecution -> {
            Long parametroIdCalculo = jobExecution.getJobParameters().getLong("idCalculo");
            return parametroIdCalculo.equals(idCalculo);
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException(String.format("A gera\u00e7\u00e3o de carn\u00ea do c\u00e1lculo %d j\u00e1 se encontra em processamento.", idCalculo));
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idCalculo", idCalculo);
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.calculoGeracaoCarneBatchJob, jobParametersBuilder.toJobParameters());
    }
}

