/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.service.PagamentoLoteService;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class BaixaAutomaticaJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job baixaAutomaticaBatchJob;
    private final PagamentoLoteService pagamentoLoteService;

    public BaixaAutomaticaJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="baixaAutomaticaBatchJob") Job baixaAutomaticaBatchJob, PagamentoLoteService pagamentoLoteService) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.baixaAutomaticaBatchJob = baixaAutomaticaBatchJob;
        this.pagamentoLoteService = pagamentoLoteService;
    }

    public JobExecution startJob(Long entidade, Long exercicio, Long lote) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.BAIXA_AUTOMATICA.getTipo()).stream().anyMatch(jobExecution -> {
            Long parametroEntidade = jobExecution.getJobParameters().getLong("entidade");
            Long parametroExercicio = jobExecution.getJobParameters().getLong("exercicio");
            Long parametroLote = jobExecution.getJobParameters().getLong("lote");
            return parametroEntidade.equals(entidade) && parametroExercicio.equals(exercicio) && parametroLote.equals(lote);
        });
        if (existeJobComMesmosParametros) {
            throw new EloValidationException("Este lote j\u00e1 se encontra em processamento.");
        }
        PagamentoLote pagamentoLote = this.pagamentoLoteService.findByPagamentoLote(entidade, exercicio, lote);
        pagamentoLote.verificaSituacaoLote();
        pagamentoLote.verificaTipoDeArquivoRetorno();
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addLong("exercicio", exercicio);
        jobParametersBuilder.addLong("lote", lote);
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.baixaAutomaticaBatchJob, jobParametersBuilder.toJobParameters());
    }
}

