/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo.correcao;

import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.IndiceCorrecao;
import br.com.elotech.tributos.domain.acrescimo.TipoCorrecao;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculoCorrecaoUtils {
    private CalculoCorrecaoUtils() {
    }

    public static LocalDate novaDataPagamento(FormaCorrecao formaCorrecao, LocalDate dataBaseCalculo, LocalDate dataRerefencia) {
        if (formaCorrecao.getMeses() == 0L) {
            return dataRerefencia;
        }
        LocalDate retorno = dataBaseCalculo;
        while (!retorno.plusMonths(formaCorrecao.getMeses()).isAfter(dataRerefencia)) {
            retorno = retorno.plusMonths(formaCorrecao.getMeses());
        }
        if (retorno.getMonthValue() == dataBaseCalculo.getMonthValue()) {
            retorno = retorno.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
        }
        return retorno;
    }

    public static ValorIndice getUltimoValorIndice(IndiceComposto indiceComposto, LocalDate dataBaseCalculo, LocalDate dataRerefencia) {
        LocalDate dataLimite = indiceComposto.getDataFinal().isBefore(dataRerefencia) ? indiceComposto.getDataFinal() : dataRerefencia;
        return Optional.ofNullable(indiceComposto.getIndiceCorrecao().getUltimoValorIndiceByData(dataLimite)).orElseThrow(() -> CalculoCorrecaoException.valorIndiceNotDefined((LocalDate)dataBaseCalculo, (IndiceCorrecao)indiceComposto.getIndiceCorrecao()));
    }

    public static ValorIndice getValorByIndiceCorrecao(IndiceComposto indiceComposto, LocalDate dataBaseCalculo) {
        return Optional.ofNullable(indiceComposto.getIndiceCorrecao().getValorIndiceByData(dataBaseCalculo)).orElseThrow(() -> CalculoCorrecaoException.valorIndiceNotDefined((LocalDate)dataBaseCalculo, (IndiceCorrecao)indiceComposto.getIndiceCorrecao()));
    }

    public static IndiceComposto getIndiceCompostoByData(FormaCorrecao formaCorrecao, LocalDate dataBaseCalculo) {
        return formaCorrecao.getIndices().stream().filter(indice -> !dataBaseCalculo.isBefore(indice.getDataInicial()) && !dataBaseCalculo.isAfter(indice.getDataFinal())).findFirst().orElseThrow(() -> CalculoCorrecaoException.periodoFormaCorrecaoNotDefined((FormaCorrecao)formaCorrecao, (LocalDate)dataBaseCalculo));
    }

    public static ValorIndice getValorIndice(FormaCorrecao formaCorrecao, IndiceComposto lastIndiceComposto, IndiceComposto indiceComposto, LocalDate dataBaseCalculo) {
        if (Objects.isNull(indiceComposto)) {
            throw CalculoCorrecaoException.periodoFormaCorrecaoNotDefined((FormaCorrecao)formaCorrecao, (LocalDate)dataBaseCalculo);
        }
        if (Objects.nonNull(lastIndiceComposto) && !lastIndiceComposto.equals((Object)indiceComposto) && indiceComposto.getSobreporPeriodo().booleanValue()) {
            return CalculoCorrecaoUtils.getValorByIndiceCorrecao((IndiceComposto)lastIndiceComposto, (LocalDate)dataBaseCalculo);
        }
        return CalculoCorrecaoUtils.getValorByIndiceCorrecao((IndiceComposto)indiceComposto, (LocalDate)dataBaseCalculo);
    }

    public static BigDecimal converteMoeda(BigDecimal valor, LocalDate dataLancamento, LocalDate dataVencimento, FormaCorrecao formaCorrecao) {
        LocalDate dataParaCalculo = formaCorrecao.getTipoCorrecao().equals((Object)TipoCorrecao.DATA_LANCAMENTO) ? dataLancamento : dataVencimento;
        IndiceComposto indiceComposto = CalculoCorrecaoUtils.getIndiceCompostoByData((FormaCorrecao)formaCorrecao, (LocalDate)dataParaCalculo);
        ValorIndice valorIndice = Optional.ofNullable(indiceComposto.getIndiceCorrecao().getUltimoValorIndiceByData(dataParaCalculo)).orElseThrow(() -> CalculoCorrecaoException.valorIndiceNotFound((LocalDate)dataParaCalculo));
        return valor.multiply(valorIndice.getValor());
    }
}

