/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.repository.TributoRepository;
import br.com.elotech.tributos.service.ContextService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TributoService
extends CrudService<Tributo, Long> {
    private final TributoRepository tributoRepository;
    private final ContextService contextService;

    public TributoService(TributoRepository tributoRepository, ContextService contextService) {
        this.tributoRepository = tributoRepository;
        this.contextService = contextService;
    }

    public Tributo findByEntidadeAndExercicioAndTributo(Long entidade, Long exercicio, String tributo) {
        return this.tributoRepository.findByEntidadeAndExercicioAndTributo(entidade, exercicio, tributo);
    }

    public Page<Tributo> findTributoByExercicioAtualAndRsql(String search, Pageable pageable) {
        search = String.format("exercicio==%d %s", this.contextService.getExercicioAtual(), search.isEmpty() ? "" : "and " + search);
        return this.findByRsql(search, pageable);
    }
}

