/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.RepresentanteLegal;
import br.com.elotech.tributos.dto.RepresentanteLegalDTO;
import br.com.elotech.tributos.repository.RepresentanteLegalRepository;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class RepresentanteLegalService {
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final RepresentanteLegalRepository representanteLegalRepository;

    public RepresentanteLegalService(CadastroMobiliarioService cadastroMobiliarioService, RepresentanteLegalRepository representanteLegalRepository) {
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.representanteLegalRepository = representanteLegalRepository;
    }

    public List<RepresentanteLegalDTO> getByCadastroMobiliarioId(Long idCadastroMobiliario) {
        return this.cadastroMobiliarioService.findById((Serializable)idCadastroMobiliario).map(cadastroMobiliario -> cadastroMobiliario.getRepresentantesLegais().stream().map(RepresentanteLegalDTO::from).sorted(Comparator.comparing(RepresentanteLegalDTO::getId).reversed()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public RepresentanteLegalDTO save(RepresentanteLegalDTO representanteLegalDTO) {
        RepresentanteLegal representanteLegal = RepresentanteLegal.from((RepresentanteLegalDTO)representanteLegalDTO);
        this.validate(representanteLegal, null);
        return RepresentanteLegalDTO.from((RepresentanteLegal)((RepresentanteLegal)this.representanteLegalRepository.save((Object)representanteLegal)));
    }

    public RepresentanteLegalDTO update(Long idRepresentanteLegal, RepresentanteLegalDTO representanteLegalDTO) {
        RepresentanteLegal representanteLegalToMerge = RepresentanteLegal.from((RepresentanteLegalDTO)representanteLegalDTO);
        RepresentanteLegal representanteLegalFound = (RepresentanteLegal)this.representanteLegalRepository.findOne((Object)idRepresentanteLegal);
        this.validate(representanteLegalToMerge, representanteLegalFound);
        if (!representanteLegalToMerge.getId().equals(representanteLegalFound.getId())) {
            throw new EloValidationException("Para atualizar os dados, os cadastros devem ser os mesmos.");
        }
        return RepresentanteLegalDTO.from((RepresentanteLegal)((RepresentanteLegal)this.representanteLegalRepository.save((Object)representanteLegalFound.merge(representanteLegalToMerge))));
    }

    private void validate(RepresentanteLegal representanteLegal, RepresentanteLegal representanteLegalOriginal) {
        if (representanteLegal.getData().isAfter(LocalDate.now())) {
            throw new EloValidationException("A data informada deve ser menor ou igual a atual.");
        }
        if ((Objects.isNull(representanteLegalOriginal) || !representanteLegal.getPessoa().getId().equals(representanteLegalOriginal.getPessoa().getId())) && this.cadastroMobiliarioService.findById((Serializable)representanteLegal.getCadastroMobiliario().getId()).map(cadastroMobiliario -> cadastroMobiliario.getRepresentantesLegais().stream().anyMatch(representanteLegalInner -> representanteLegalInner.getPessoa().getId().equals(representanteLegal.getPessoa().getId()))).orElse(false).booleanValue()) {
            throw new EloValidationException("Representante j\u00e1 vinculado a este cadastro mobiliario.");
        }
    }

    public void delete(Long idRepresentanteLegal) {
        RepresentanteLegal representanteLegal = (RepresentanteLegal)this.representanteLegalRepository.findById((Object)idRepresentanteLegal).orElseThrow(() -> new EloValidationException(String.format("Representante legal com id %d encontrado", idRepresentanteLegal)));
        this.representanteLegalRepository.delete((Object)representanteLegal);
    }
}

