/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.domain.LivroRegistroId;
import br.com.elotech.tributos.dto.dividaativa.LivroRegistroDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroRegistroParcelaDTO;
import br.com.elotech.tributos.repository.LivroRegistroRepository;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LivroRegistroService
extends CrudService<LivroRegistro, LivroRegistroId> {
    private final LivroRegistroRepository livroRegistroRepository;

    public LivroRegistroService(LivroRegistroRepository livroRegistroRepository) {
        this.livroRegistroRepository = livroRegistroRepository;
    }

    public Page<LivroRegistroDTO> searchItens(Long entidade, Long exercicio, Long livro, String search, Pageable pageable) {
        String finalRsql = String.format("id.livro.id.entidade == %d and id.livro.id.exercicio == %d and id.livro.id.livro == %d ", entidade, exercicio, livro);
        String searchWithClause = search.isEmpty() ? finalRsql : String.format("(%s) and (%s)", finalRsql, search);
        Specification subQuerySpecification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), LivroRegistro.class, (String)searchWithClause);
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Subquery subquery = query.subquery(LivroRegistro.class);
            Root subQueryRoot = subquery.from(LivroRegistro.class);
            subquery.select((Expression)subQueryRoot.get("numeroInscricao")).where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get("id"), (Expression)subQueryRoot.get("id")), (Expression)subQuerySpecification.toPredicate(subQueryRoot, query, criteriaBuilder)));
            return criteriaBuilder.exists(subquery);
        };
        return this.livroRegistroRepository.findAll((Specification)specification, pageable).map(LivroRegistroDTO::of);
    }

    public List<LivroRegistroParcelaDTO> getParcelaTributosByLivroRegistro(Long entidade, Long exercicio, Long livro, Long sequencia) {
        return ((LivroRegistro)this.livroRegistroRepository.findById((Object)LivroRegistroId.of((Long)entidade, (Long)exercicio, (Long)livro, (Long)sequencia)).orElseThrow(() -> new EloValidationException("Esse registro n\u00e3o possui nenhuma parcela inscrita"))).getParcelasAgrupadas();
    }
}

