/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.report.loader.EspelhoImobiliarioParamLoader;
import br.com.elotech.tributos.report.loader.EspelhoMobiliarioParamLoader;
import br.com.elotech.tributos.service.ImpressaoEspelhoCadastrosService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.RelatorioService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ImpressaoEspelhoCadastrosService {
    private final EspelhoImobiliarioParamLoader espelhoImobiliarioParamLoader;
    private final EspelhoMobiliarioParamLoader espelhoMobiliarioParamLoader;
    private final ParametroGeralService parametroGeralService;
    private final RelatorioService relatorioService;

    public ImpressaoEspelhoCadastrosService(EspelhoImobiliarioParamLoader espelhoImobiliarioParamLoader, EspelhoMobiliarioParamLoader espelhoMobiliarioParamLoader, ParametroGeralService parametroGeralService, RelatorioService relatorioService) {
        this.espelhoImobiliarioParamLoader = espelhoImobiliarioParamLoader;
        this.espelhoMobiliarioParamLoader = espelhoMobiliarioParamLoader;
        this.parametroGeralService = parametroGeralService;
        this.relatorioService = relatorioService;
    }

    public ImprimirRelatorioDTO buildImpressaoEspelhoDTO(Integer relatorioSistema, TipoCadastro tipoCadastro, Long cadastroGeral) {
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorioSistema);
        this.completeRelatorioDTO(dto, tipoCadastro, cadastroGeral);
        return dto;
    }

    private void completeRelatorioDTO(ImprimirRelatorioDTO dto, TipoCadastro tipoCadastro, Long cadastroGeral) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$TipoCadastro[tipoCadastro.ordinal()]) {
            case 1: {
                ParametroGeral parametroRelatorioCadImobiliario = this.getParametro(ParametroGeralEnum.RELATORIO_CAD_IMOBILIARIO_WEB);
                ParametroGeral parametroTipoRelatorioCadImobiliario = this.getParametro(ParametroGeralEnum.TIPO_RELATORIO_CAD_IMOBILIARIO_WEB);
                this.updateRelatorioAndTipoRelatorio(dto, parametroRelatorioCadImobiliario, parametroTipoRelatorioCadImobiliario);
                dto.setFiltro(String.format(" cg.TipoCadastro = %d and cg.CadastroGeral = %d", tipoCadastro.getValue(), cadastroGeral));
                dto.setListParametros(this.espelhoImobiliarioParamLoader.load());
                dto.setSubReports(this.getSubReportImobiliarioDTO(dto.getFiltro(), cadastroGeral));
                break;
            }
            case 2: {
                ParametroGeral parametroRelatorioCadMobiliario = this.getParametro(ParametroGeralEnum.RELATORIO_CAD_MOBILIARIO_WEB);
                ParametroGeral parametroTipoRelatorioCadMobiliario = this.getParametro(ParametroGeralEnum.TIPO_RELATORIO_CAD_MOBILIARIO_WEB);
                this.updateRelatorioAndTipoRelatorio(dto, parametroRelatorioCadMobiliario, parametroTipoRelatorioCadMobiliario);
                dto.setFiltro(String.format(" ( tcm.CadastroGeral = %d ) ", cadastroGeral));
                dto.setListParametros(this.espelhoMobiliarioParamLoader.load());
                dto.setSubReports(this.getSubReportMobiliarioDTO(dto.getFiltro()));
            }
        }
    }

    private ParametroGeral getParametro(ParametroGeralEnum parametroGeralEnum) {
        return this.parametroGeralService.findByParametroAndModulo(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private void updateRelatorioAndTipoRelatorio(ImprimirRelatorioDTO dto, ParametroGeral parametroRelatorio, ParametroGeral parametroTipoRelatorio) {
        if (StringUtils.isBlank((CharSequence)parametroRelatorio.getValor()) || StringUtils.isBlank((CharSequence)parametroTipoRelatorio.getValor())) {
            return;
        }
        Relatorio relatorio = (Relatorio)this.relatorioService.findById((Serializable)RelatorioPK.builder().modulo(ModuloEnum.MODULO_TRIBUTARIO.getValue()).tipoRelatorio(TipoRelatorio.fromValue((String)parametroTipoRelatorio.getValor())).relatorio(Integer.valueOf(parametroRelatorio.getValor())).build()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar relat\u00f3rio com os par\u00e2metros: M\u00f3dulo: [%s], Tipo Relat\u00f3rio: [%s], Relat\u00f3rio: [%s].", ModuloEnum.MODULO_TRIBUTARIO.getValue(), TipoRelatorio.fromValue((String)parametroTipoRelatorio.getValor()).getDescricao(), parametroRelatorio.getValor())));
        dto.setRelatorio(relatorio.getRelatorio());
        dto.setTipoRelatorioFromEnum(TipoRelatorio.fromValue((String)relatorio.getTipoRelatorio().getValue()));
    }

    private SubReportDTO getSubReportImobiliarioDTO(String filtro, Long cadastroGeral) {
        SubReportDTO subReportDTO = new SubReportDTO();
        String filtroGeminada = String.format(" tcig.TipoCadastro = %d and tcig.CadastroGeral = %d", TipoCadastro.IMOBILIARIO.getValue(), cadastroGeral);
        String filtroSegmentoDemolicao = String.format(" tisd.TipoCadastro = %d and tisd.CadastroGeral = %d", TipoCadastro.IMOBILIARIO.getValue(), cadastroGeral);
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("PROPRIETARIOS", filtro), new SubReportItemDTO("TESTADA", filtro), new SubReportItemDTO("CAUCAO", filtro), new SubReportItemDTO("TERRENO", filtro), new SubReportItemDTO("SEGMENTO", filtro), new SubReportItemDTO("ObservacaoImobiliario", filtro), new SubReportItemDTO("AREAVERDE", filtro), new SubReportItemDTO("Geminada", filtroGeminada), new SubReportItemDTO("Isencao", filtro), new SubReportItemDTO("SegmentoDemolicao", filtroSegmentoDemolicao), new SubReportItemDTO("TESTADA_GENERICA", filtro)}));
        return subReportDTO;
    }

    private SubReportDTO getSubReportMobiliarioDTO(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Atividade", filtro), new SubReportItemDTO("Servico", filtro), new SubReportItemDTO("Socio", filtro), new SubReportItemDTO("Observacao", filtro), new SubReportItemDTO("BOLETIMMOBILIARIO", filtro), new SubReportItemDTO("CNAE", filtro)}));
        return subReportDTO;
    }
}

