/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.FacetCategoriaDTO;
import br.com.elotech.tributos.dto.SelectedFacetDTO;
import br.com.elotech.tributos.enums.hibernatesearch.StatusHibernateSearchIndexed;
import br.com.elotech.tributos.enums.hibernatesearch.TipoCadastroIndexacao;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.dto.IndexacaoHibernateSearchDTO;
import br.com.elotech.tributos.hibernatesearch.facet.FacetField;
import br.com.elotech.tributos.hibernatesearch.progressmonitor.HibernateSearchIndexingProgressMonitor;
import br.com.elotech.tributos.service.HibernateSearchService;
import br.com.elotech.tributos.service.hibernatesearch.HibernateSearchLockService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.lucene.search.Query;
import org.hibernate.CacheMode;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class HibernateSearchService {
    private final EntityManager entityManager;
    private final EntityManagerFactory entityManagerFactory;
    private final HibernateSearchLockService hibernateSearchLockService;
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateSearchService.class);
    private static final int PAGE_SIZE = 100;
    private static final String GET_CADASTROS_WITH_TYPE = "select %s from CadastroGeral cg where cg.tipoCadastro = :tipoCadastro";

    public HibernateSearchService(EntityManager entityManager, EntityManagerFactory entityManagerFactory, HibernateSearchLockService hibernateSearchLockService) {
        this.entityManager = entityManager;
        this.entityManagerFactory = entityManagerFactory;
        this.hibernateSearchLockService = hibernateSearchLockService;
    }

    @Transactional
    public void indexEntities(TipoCadastroIndexacao tipoCadastro, SseEmitter emitter) {
        LOGGER.info(String.format("Iniciando a indexa\u00e7\u00e3o do tipo de cadastro de %s.", tipoCadastro.getDescricao()));
        Class entityType = this.getEntityTypeFromTipoCadastro(tipoCadastro);
        this.hibernateSearchLockService.startIndexedFromTipoCadastro(tipoCadastro);
        if (tipoCadastro == TipoCadastroIndexacao.AVULSO) {
            this.indexCadastroAvulsoAsync(emitter);
            return;
        }
        try {
            Search.getFullTextEntityManager((EntityManager)this.entityManager).createIndexer(new Class[]{entityType}).purgeAllOnStart(true).batchSizeToLoadObjects(25).cacheMode(CacheMode.NORMAL).idFetchSize(150).threadsToLoadObjects(Runtime.getRuntime().availableProcessors()).progressMonitor((MassIndexerProgressMonitor)new HibernateSearchIndexingProgressMonitor(emitter, tipoCadastro, this.hibernateSearchLockService)).start();
        }
        catch (Exception ex) {
            LOGGER.error(String.format("Erro ao realizar a indexa\u00e7\u00e3o: %s", ex.getMessage()));
            IndexacaoHibernateSearchDTO indexedHibernateSearch = new IndexacaoHibernateSearchDTO();
            indexedHibernateSearch.setTipoCadastro(TipoCadastroIndexacao.AVULSO);
            indexedHibernateSearch.setCompleted(Boolean.TRUE);
            indexedHibernateSearch.setStatus(StatusHibernateSearchIndexed.ERRO);
            indexedHibernateSearch.setMessageError(ex.getMessage());
            this.hibernateSearchLockService.updateStatusHibernateSearchFromTipoCadastro(indexedHibernateSearch);
            emitter.completeWithError((Throwable)ex);
        }
    }

    @Transactional
    protected void searchAndIndexCadastroAvulso(SseEmitter emitter) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)entityManager);
        Long total = (Long)fullTextEntityManager.createQuery(String.format(GET_CADASTROS_WITH_TYPE, "count(cg) as total"), Long.class).setParameter("tipoCadastro", (Object)TipoCadastro.AVULSO).getSingleResult();
        Long indexed = 0L;
        try {
            while (total > indexed) {
                List cadastrosAvulsos = this.getCadastrosAvulsos(fullTextEntityManager, indexed);
                for (CadastroGeral cadastroAvulso : cadastrosAvulsos) {
                    Long l = indexed;
                    Long l2 = indexed = Long.valueOf(indexed + 1L);
                    fullTextEntityManager.index((Object)cadastroAvulso);
                    emitter.send(SseEmitter.event().id(UUID.randomUUID().toString()).data((Object)new IndexacaoHibernateSearchDTO(total, indexed), MediaType.APPLICATION_JSON));
                }
                fullTextEntityManager.flushToIndexes();
            }
            IndexacaoHibernateSearchDTO indexedHibernateSearch = new IndexacaoHibernateSearchDTO(total, indexed);
            indexedHibernateSearch.setTipoCadastro(TipoCadastroIndexacao.AVULSO);
            indexedHibernateSearch.setCompleted(Boolean.TRUE);
            indexedHibernateSearch.setStatus(StatusHibernateSearchIndexed.SUCESSO);
            this.hibernateSearchLockService.updateStatusHibernateSearchFromTipoCadastro(indexedHibernateSearch);
            emitter.send(SseEmitter.event().id(UUID.randomUUID().toString()).data((Object)indexedHibernateSearch, MediaType.APPLICATION_JSON));
            emitter.complete();
        }
        catch (IOException e) {
            LOGGER.error(String.format("Erro ao realizar a indexa\u00e7\u00e3o %d/%d: %s", indexed, total, e.getMessage()));
        }
    }

    @Transactional
    public void indexEntities(Class<?> entityType) throws InterruptedException {
        LOGGER.info(String.format("Iniciando a indexa\u00e7\u00e3o das entidades de %s.", entityType.getName()));
        int maxThreads = Runtime.getRuntime().availableProcessors();
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
        fullTextEntityManager.createIndexer(new Class[]{entityType}).purgeAllOnStart(true).batchSizeToLoadObjects(25).cacheMode(CacheMode.NORMAL).idFetchSize(150).threadsToLoadObjects(maxThreads).startAndWait();
        LOGGER.info(String.format("Finalizada a indexa\u00e7\u00e3o das entidades de %s.", entityType.getName()));
    }

    public <T> void indexEntity(T entity) {
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.entityManager);
        fullTextEntityManager.index(entity);
        fullTextEntityManager.flushToIndexes();
    }

    public FullTextQuery searchEntities(HibernateSearchParams hibernateSearchParams, Query query, List<SelectedFacetDTO> selectedFacetsDTO) {
        FullTextQuery fullTextQuery = hibernateSearchParams.createFullTextQuery(query);
        hibernateSearchParams.getFacets().forEach(facetField -> this.enableFacet(hibernateSearchParams.getQueryBuilder(), fullTextQuery, facetField));
        selectedFacetsDTO.forEach(facetSelecionado -> this.aplicaFacetSelecionado(fullTextQuery, facetSelecionado));
        return fullTextQuery;
    }

    public Map<String, FacetCategoriaDTO> getFacetsDisponiveis(FacetManager facetManager, List<FacetField> facets, List<SelectedFacetDTO> selectedFacetsDTO) {
        this.desmarcaFacetsSelecionadosIndisponiveisDevidoAOutrosFacets(facetManager, selectedFacetsDTO);
        return this.getFacetsDisponiveisParaSelecao(facetManager, facets);
    }

    public <A, B> CadastroSearchDTO<B> geraCadastroSearchDTO(Query query, HibernateSearchParams hibernateSearchParams, List<SelectedFacetDTO> selectedFacetsDTO, Function<A, B> converteEntityToDTO) {
        FullTextQuery fullTextQuery = this.searchEntities(hibernateSearchParams, query, selectedFacetsDTO);
        CadastroSearchDTO dto = new CadastroSearchDTO();
        dto.setFacets(this.getFacetsDisponiveis(fullTextQuery.getFacetManager(), hibernateSearchParams.getFacets(), selectedFacetsDTO));
        List cadastros = fullTextQuery.getResultList().stream().map(converteEntityToDTO).collect(Collectors.toList());
        dto.setCadastros((Page)new PageImpl(cadastros, hibernateSearchParams.getPageable(), (long)fullTextQuery.getResultSize()));
        return dto;
    }

    private void indexCadastroAvulsoAsync(SseEmitter emitter) {
        new ThreadPoolTaskExecutor().execute(() -> {
            try {
                this.searchAndIndexCadastroAvulso(emitter);
            }
            catch (Exception ex) {
                LOGGER.error(String.format("Erro ao realizar a indexa\u00e7\u00e3o: %s", ex.getMessage()));
                IndexacaoHibernateSearchDTO indexedHibernateSearch = new IndexacaoHibernateSearchDTO();
                indexedHibernateSearch.setTipoCadastro(TipoCadastroIndexacao.AVULSO);
                indexedHibernateSearch.setCompleted(Boolean.TRUE);
                indexedHibernateSearch.setStatus(StatusHibernateSearchIndexed.ERRO);
                indexedHibernateSearch.setMessageError(ex.getMessage());
                this.hibernateSearchLockService.updateStatusHibernateSearchFromTipoCadastro(indexedHibernateSearch);
                emitter.completeWithError((Throwable)ex);
            }
        });
    }

    private List<CadastroGeral> getCadastrosAvulsos(FullTextEntityManager fullTextEntityManager, Long skipSize) {
        return fullTextEntityManager.createQuery(String.format(GET_CADASTROS_WITH_TYPE, "cg"), CadastroGeral.class).setParameter("tipoCadastro", (Object)TipoCadastro.AVULSO).setFirstResult(skipSize.intValue()).setMaxResults(100).getResultList();
    }

    private Class<?> getEntityTypeFromTipoCadastro(TipoCadastroIndexacao tipoCadastro) {
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$hibernatesearch$TipoCadastroIndexacao[tipoCadastro.ordinal()]) {
            case 1: 
            case 2: {
                return CadastroGeral.class;
            }
            case 3: {
                return CadastroImobiliario.class;
            }
            case 4: {
                return CadastroMobiliario.class;
            }
            case 5: {
                return CadastroRural.class;
            }
        }
        throw new EloValidationException(String.format("Indexa\u00e7\u00e3o n\u00e3o implementada para o tipo de cadastro %s!", tipoCadastro.getDescricao()));
    }

    private void desmarcaFacetsSelecionadosIndisponiveisDevidoAOutrosFacets(FacetManager facetManager, List<SelectedFacetDTO> selectedFacetsDTO) {
        selectedFacetsDTO.forEach(selectedFacetDTO -> {
            List selectedFacets = facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).getSelectedFacets();
            if (facetManager.getFacets(selectedFacetDTO.getFacetName()).stream().noneMatch(facet -> facet.getValue().equals(selectedFacetDTO.getFacetValue()))) {
                Facet facet2 = selectedFacets.stream().filter(selectFacet -> selectFacet.getValue().equals(selectedFacetDTO.getFacetValue())).findFirst().orElse(null);
                facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).deselectFacets(new Facet[]{facet2});
            }
        });
    }

    private Map<String, FacetCategoriaDTO> getFacetsDisponiveisParaSelecao(FacetManager facetManager, List<FacetField> facets) {
        LinkedHashMap<String, FacetCategoriaDTO> facetsDisponiveis = new LinkedHashMap<String, FacetCategoriaDTO>();
        facets.forEach(facetField -> {
            ArrayList facetsSelecionados = new ArrayList(facetManager.getFacetGroup(facetField.getName()).getSelectedFacets());
            facetManager.getFacetGroup(facetField.getName()).clearSelectedFacets();
            facetsDisponiveis.put(facetField.getName(), FacetCategoriaDTO.of((FacetField)facetField, (List)facetManager.getFacets(facetField.getName())));
            facetManager.getFacetGroup(facetField.getName()).selectFacets(facetsSelecionados.toArray(new Facet[0]));
        });
        return facetsDisponiveis;
    }

    private void enableFacet(QueryBuilder queryBuilder, FullTextQuery fullTextQuery, FacetField facetField) {
        FacetManager facetManager = fullTextQuery.getFacetManager();
        FacetingRequest facetingRequest = facetField.getIsRangeType() != false ? this.createRangeFacetingRequest(queryBuilder, facetField.getName()) : this.createDiscreteFacetingRequest(queryBuilder, facetField.getName());
        facetManager.enableFaceting(facetingRequest);
    }

    private FacetingRequest createRangeFacetingRequest(QueryBuilder queryBuilder, String facetName) {
        return queryBuilder.facet().name(facetName).onField(facetName).range().below((Object)50).from((Object)51).to((Object)100).from((Object)101).to((Object)250).from((Object)251).to((Object)500).from((Object)501).to((Object)1000).above((Object)1001).orderedBy(FacetSortOrder.RANGE_DEFINITION_ORDER).createFacetingRequest();
    }

    private FacetingRequest createDiscreteFacetingRequest(QueryBuilder queryBuilder, String facetName) {
        int numeroMaximoFacets = 1000000;
        return queryBuilder.facet().name(facetName).onField(facetName).discrete().orderedBy(FacetSortOrder.FIELD_VALUE).includeZeroCounts(false).maxFacetCount(1000000).createFacetingRequest();
    }

    private void aplicaFacetSelecionado(FullTextQuery fullTextQuery, SelectedFacetDTO selectedFacetDTO) {
        FacetManager facetManager = fullTextQuery.getFacetManager();
        if (fullTextQuery.getResultSize() > 0) {
            ArrayList facetsJaSelecionados = new ArrayList(facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).getSelectedFacets());
            facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).clearSelectedFacets();
            List facetsDisponiveis = facetManager.getFacets(selectedFacetDTO.getFacetName());
            Facet[] facetsDisponiveisSelecionados = (Facet[])facetsDisponiveis.stream().filter(facetDisponivel -> facetDisponivel.getValue().equals(selectedFacetDTO.getFacetValue()) || facetsJaSelecionados.contains(facetDisponivel)).toArray(Facet[]::new);
            facetManager.getFacetGroup(selectedFacetDTO.getFacetName()).selectFacets(facetsDisponiveisSelecionados);
        }
    }
}

