/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.TipoDivisaoUnificacaoLote;
import br.com.elotech.tributos.domain.TipoImovel;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.DivisaoUnificacaoLote;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.DesmembrarCadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ObservacaoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.util.ListUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DivisaoUnificacaoLoteService
extends CrudService<DivisaoUnificacaoLote, Long> {
    private final CadastroImobiliarioService cadastroImobiliarioService;

    public DivisaoUnificacaoLoteService(CadastroImobiliarioService cadastroImobiliarioService) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
    }

    public Long desmembrar(DesmembrarCadastroImobiliarioDTO desmembramento) {
        CadastroImobiliario cadastroImobiliarioOrigem = (CadastroImobiliario)this.cadastroImobiliarioService.findOne((Serializable)this.cadastroImobiliarioService.saveDTOWithFlush(desmembramento.getCadastroOrigem(), Boolean.FALSE, Boolean.FALSE).getId());
        String usuario = SecurityUtils.getUserAise();
        String observacao = String.format("Desmembramento do Cadastro %d, gerando o(s) Novo(s) Cadastro(s): %s", desmembramento.getCadastroOrigem().getCadastroGeral(), desmembramento.getNovosCadastros().stream().map(CadastroImobiliarioDTO::getCadastroGeral).map(Object::toString).collect(Collectors.joining(", ")));
        desmembramento.getNovosCadastros().stream().forEach(cadastro -> {
            ListUtils.forEachWithCounter((Iterable)cadastro.getProfundidades(), (index, profundidade) -> {
                profundidade.setId(null);
                profundidade.setSequencia(Long.valueOf(index + 1L));
            });
            ListUtils.forEachWithCounter((Iterable)cadastro.getSegmentos(), (index, segmento) -> {
                segmento.setId(null);
                segmento.setSequencia(Long.valueOf(index + 1L));
                segmento.getRespostasSegmento().forEach(resposta -> {
                    resposta.setId(null);
                    resposta.getRespostasPreenchidas().forEach(respostaPreenchida -> respostaPreenchida.setId(null));
                });
            });
            cadastro.getProprietarios().forEach(proprietario -> proprietario.setId(null));
            cadastro.getTestadas().forEach(testada -> testada.setId(null));
            cadastro.getTestadasGenericas().forEach(testada -> testada.setId(null));
            cadastro.getRespostasTerreno().forEach(resposta -> {
                resposta.setId(null);
                resposta.getRespostasPreenchidas().forEach(respostaPreenchida -> respostaPreenchida.setId(null));
            });
            cadastro.getObservacoes().clear();
            cadastro.getObservacoes().add(new ObservacaoDTO(Long.valueOf(1L), observacao, LocalDate.now(), usuario));
            if (cadastro.getSegmentos().isEmpty() && TipoImovel.PREDIAL.equals((Object)cadastro.getTipoImovel())) {
                cadastro.setTipoImovel(TipoImovel.TERRITORIAL);
            }
        });
        List cadastrosSalvos = desmembramento.getNovosCadastros().stream().map(cadastro -> this.cadastroImobiliarioService.saveDTOWithFlush(cadastro, Boolean.TRUE, Boolean.FALSE)).map(CadastroImobiliarioDTO::getId).map(arg_0 -> ((CadastroImobiliarioService)this.cadastroImobiliarioService).findOne(arg_0)).collect(Collectors.toList());
        DivisaoUnificacaoLote divisaoUnificacaoLote = new DivisaoUnificacaoLote();
        divisaoUnificacaoLote.setCadastroImobiliario(cadastroImobiliarioOrigem);
        divisaoUnificacaoLote.setTipo(TipoDivisaoUnificacaoLote.DIVISAO);
        divisaoUnificacaoLote.setData(LocalDateTime.now());
        divisaoUnificacaoLote.setUsuario(usuario);
        divisaoUnificacaoLote.setObservacao(observacao);
        divisaoUnificacaoLote.getCadastrosImobiliarios().addAll(cadastrosSalvos);
        return ((DivisaoUnificacaoLote)this.save((EloEntity)divisaoUnificacaoLote, null)).getId();
    }
}

