/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.TributoDTO;
import br.com.elotech.tributos.params.DebitoFilterParams;
import br.com.elotech.tributos.params.DebitoTributosPorcentagemParams;
import br.com.elotech.tributos.repository.DebitoParcelaTributoRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DebitoParcelaTributoService
extends CrudService<DebitoParcelaTributo, Long> {
    private static final Integer TODAS_SITUACOES_LEGAL = 3;
    private final DebitoParcelaTributoRepository debitoParcelaTributoRepository;

    public DebitoParcelaTributoService(DebitoParcelaTributoRepository debitoParcelaTributoRepository) {
        this.debitoParcelaTributoRepository = debitoParcelaTributoRepository;
    }

    public List<DebitoParcelaTributo> findByDebitoParcelaDebitoIdAndTributo(Long id, String tributo) {
        return this.debitoParcelaTributoRepository.findByDebitoParcelaDebitoIdAndTributo(id, tributo);
    }

    public List<CancelamentoDebitoTributoDTO> findByDebitoAndAberto(DebitoFilterParams debito, Integer situacaoLegal) {
        return this.debitoParcelaTributoRepository.findByDebitoAndAberto(debito, this.getSituacaoLegal(situacaoLegal));
    }

    public List<TributoDTO> getDebitoTributoDescricao(DebitoFilterParams params, Integer situacaoLegal) {
        return this.debitoParcelaTributoRepository.findDebitoDescricao(params, this.getSituacaoLegal(situacaoLegal));
    }

    public List<CancelamentoDebitoTributoDTO> getDebitoParcelaTributoCancelamento(DebitoTributosPorcentagemParams params) {
        List situacoesLegais = this.getSituacaoLegal(params.getSituacaoLegal());
        ArrayList debitoParcelaTributoCancelamento = new ArrayList();
        params.getTributos().forEach(tributo -> debitoParcelaTributoCancelamento.addAll(this.debitoParcelaTributoRepository.findDebitoParcelaTributoCancelamento(params.getDebitoFilters(), tributo, situacoesLegais)));
        Comparator<CancelamentoDebitoTributoDTO> comparator = Comparator.comparing(CancelamentoDebitoTributoDTO::getEntidade).thenComparing(CancelamentoDebitoTributoDTO::getExercicio).thenComparing(CancelamentoDebitoTributoDTO::getTipoCadastro).thenComparing(CancelamentoDebitoTributoDTO::getCadastroGeral).thenComparing(CancelamentoDebitoTributoDTO::getDivida).thenComparing(CancelamentoDebitoTributoDTO::getSubDivida).thenComparing(CancelamentoDebitoTributoDTO::getParcela).thenComparing(CancelamentoDebitoTributoDTO::getTributo);
        return debitoParcelaTributoCancelamento.stream().sorted(comparator).collect(Collectors.toList());
    }

    private List<Integer> getSituacaoLegal(Integer situacaoLegal) {
        if (TODAS_SITUACOES_LEGAL.equals(situacaoLegal)) {
            return Arrays.asList(SituacaoLegal.NO_EXERCICIO.getValue(), SituacaoLegal.DIVIDA_ATIVA.getValue(), SituacaoLegal.JUIZO.getValue());
        }
        return Arrays.asList(situacaoLegal);
    }

    public List<DebitoParcelaTributo> saveAll(List<DebitoParcelaTributo> entities) {
        return this.debitoParcelaTributoRepository.saveAll(entities);
    }
}

