/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoObservacaoId;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.repository.DebitoObservacaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DebitoObservacaoService {
    private final DebitoObservacaoRepository debitoObservacaoRepository;

    public DebitoObservacaoService(DebitoObservacaoRepository debitoObservacaoRepository) {
        this.debitoObservacaoRepository = debitoObservacaoRepository;
    }

    public List<DebitoObservacao> findByDebito(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long divida, Long subdivida) {
        return this.debitoObservacaoRepository.findByDebito(entidade, exercicio, tipoCadastro, cadastroGeral, divida, subdivida);
    }

    public DebitoObservacao save(DebitoObservacao debitoObservacao) {
        if (Objects.isNull(debitoObservacao.getDataInclusao())) {
            debitoObservacao.setDataInclusao(LocalDate.now());
        }
        if (Objects.isNull(debitoObservacao.getUsuario())) {
            debitoObservacao.setUsuario(SecurityUtils.getUserAise());
        }
        if (Objects.isNull(debitoObservacao.getId().getSequencia())) {
            debitoObservacao.getId().setSequencia(Long.valueOf(this.debitoObservacaoRepository.findLastSequencia(debitoObservacao.getId().getEntidade(), debitoObservacao.getId().getExercicio(), debitoObservacao.getId().getTipoCadastro(), debitoObservacao.getId().getCadastroGeral(), debitoObservacao.getId().getDivida(), debitoObservacao.getId().getSubDivida()) + 1L));
        }
        return (DebitoObservacao)this.debitoObservacaoRepository.save((Object)debitoObservacao);
    }

    @Transactional
    public DebitoObservacao save(DebitoIdDTO debitoIdDTO, String observacao) {
        DebitoObservacaoId debitoObservacaoId = new DebitoObservacaoId();
        debitoObservacaoId.setEntidade(debitoIdDTO.getEntidade());
        debitoObservacaoId.setExercicio(debitoIdDTO.getExercicio());
        debitoObservacaoId.setTipoCadastro(debitoIdDTO.getTipoCadastro());
        debitoObservacaoId.setCadastroGeral(debitoIdDTO.getCadastroGeral());
        debitoObservacaoId.setDivida(debitoIdDTO.getDivida());
        debitoObservacaoId.setSubDivida(debitoIdDTO.getSubDivida());
        DebitoObservacao debitoObservacao = new DebitoObservacao();
        debitoObservacao.setId(debitoObservacaoId);
        debitoObservacao.setObservacao(observacao);
        return this.save(debitoObservacao);
    }
}

