/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocial;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocialPessoa;
import br.com.elotech.tributos.dto.ContratoSocialDTO;
import br.com.elotech.tributos.repository.ContratoSocialRepository;
import br.com.elotech.tributos.repository.mobiliario.CadastroMobiliarioRepository;
import java.math.BigDecimal;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class ContratoSocialService {
    private final ContratoSocialRepository contratoSocialRepository;
    private final CadastroMobiliarioRepository cadastroMobiliarioRepository;

    public ContratoSocialService(ContratoSocialRepository contratoSocialRepository, CadastroMobiliarioRepository cadastroMobiliarioRepository) {
        this.contratoSocialRepository = contratoSocialRepository;
        this.cadastroMobiliarioRepository = cadastroMobiliarioRepository;
    }

    public ContratoSocial findById(Long id) {
        return (ContratoSocial)this.contratoSocialRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o contrato social com o id: %d.", id)));
    }

    public ContratoSocialDTO save(ContratoSocialDTO contratoSocialDTO) {
        ContratoSocial contratoSocial = this.getContratoSocialEntityAndValidate(contratoSocialDTO);
        return ContratoSocialDTO.from((ContratoSocial)((ContratoSocial)this.contratoSocialRepository.save((Object)contratoSocial)));
    }

    public ContratoSocialDTO update(ContratoSocialDTO contratoSocialDTO) {
        if (!this.contratoSocialRepository.isContratoAtual(contratoSocialDTO.getCadastroMobiliario(), contratoSocialDTO.getSequencia()).booleanValue()) {
            throw new EloValidationException("Edi\u00e7\u00e3o permitida apenas para o contrato social atual.");
        }
        ContratoSocial contratoSocialToMerge = this.getContratoSocialEntityAndValidate(contratoSocialDTO);
        ContratoSocial contratoSocialFound = this.findById(contratoSocialToMerge.getId());
        return ContratoSocialDTO.from((ContratoSocial)((ContratoSocial)this.contratoSocialRepository.save((Object)contratoSocialFound.merge(contratoSocialToMerge))));
    }

    private ContratoSocial getContratoSocialEntityAndValidate(ContratoSocialDTO contratoSocialDTO) {
        ContratoSocial contratoSocial = contratoSocialDTO.toEntity();
        CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)this.cadastroMobiliarioRepository.findById((Object)contratoSocialDTO.getCadastroMobiliario()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro mobili\u00e1rio com o id: %d.", contratoSocialDTO.getCadastroMobiliario())));
        contratoSocial.setCadastroMobiliario(cadastroMobiliario);
        if (Objects.isNull(contratoSocial.getSequencia())) {
            contratoSocial.setSequencia(this.contratoSocialRepository.findProximaSequencia(cadastroMobiliario.getId()));
        }
        if (contratoSocial.getPessoas().stream().noneMatch(ContratoSocialPessoa::getResponsavel)) {
            throw new EloValidationException("\u00c9 obrigat\u00f3rio ter ao menos um respons\u00e1vel principal vinculado ao contrato social.");
        }
        if (BigDecimal.valueOf(100L).compareTo(contratoSocial.getTotalPercentualSocios()) > 0) {
            throw new EloValidationException("O total da soma dos percentuais dos s\u00f3cios deve ser 100%.");
        }
        return contratoSocial;
    }
}

