/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.service.ContextService;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ContaBancariaService
extends CrudService<ContaBancaria, Long> {
    private static final String CONTA_BANCARIA = "contaBancaria";
    private final ContextService contextService;

    public ContaBancariaService(ContextService contextService) {
        this.contextService = contextService;
    }

    public Page<ContaBancaria> findByVinculoConvenio(String search, Pageable pageable) {
        String idClause = String.format("entidade==%d and contaArrecadacao==true", this.contextService.getEntidadePrincipal());
        String searchWithIdClause = search.isEmpty() ? idClause : String.format("(%s) and (%s)", idClause, search);
        Specification rsqlSpec = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), (String)searchWithIdClause);
        Specification & Serializable subQuerySpec = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Subquery subquery = query.subquery(Long.class);
            subquery.select(criteriaBuilder.literal((Object)1L));
            Root subQueryRoot = subquery.from(Convenio.class);
            subquery.where(new Predicate[]{criteriaBuilder.equal((Expression)subQueryRoot.get("entidade"), (Expression)root.get("entidade")), criteriaBuilder.equal((Expression)subQueryRoot.get(CONTA_BANCARIA).get(CONTA_BANCARIA), (Expression)root.get(CONTA_BANCARIA))});
            return criteriaBuilder.exists(subquery);
        };
        Specification fullSpec = Specification.where((Specification)subQuerySpec.and(rsqlSpec));
        return this.getRepository().findAll(fullSpec, pageable);
    }
}

