/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.tributos.dto.ComunicadoDTO;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoService {
    private final ComunicadoRepository comunicadoRepository;
    private final EntidadeService entidadeService;

    public ComunicadoService(ComunicadoRepository comunicadoRepository, EntidadeService entidadeService) {
        this.comunicadoRepository = comunicadoRepository;
        this.entidadeService = entidadeService;
    }

    public List<ComunicadoDTO> findAllComunicadosByEntidadeAndExercicioAndValidade(Optional<Long> entidadeParam, Optional<Long> exercicioParam, Optional<LocalDate> dataValidadeParam) {
        Long entidade = entidadeParam.orElse(this.entidadeService.findEntidadePrincipal().getId());
        Long exercicio = exercicioParam.orElse(Long.valueOf(LocalDate.now().getYear()));
        LocalDate dataValidade = dataValidadeParam.orElse(LocalDate.now());
        return this.comunicadoRepository.findAllByEntidadeAndExercicioAndDataValidade(entidade, exercicio, dataValidade);
    }
}

