/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.tributos.dto.ComunicadoCadastroDTO;
import br.com.elotech.tributos.repository.ComunicadoCadastroRepository;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoCadastroService {
    private final ComunicadoCadastroRepository comunicadoCadastroReporitory;
    private final EntidadeService entidadeService;

    public ComunicadoCadastroService(ComunicadoCadastroRepository comunicadoCadastroReporitory, EntidadeService entidadeService) {
        this.comunicadoCadastroReporitory = comunicadoCadastroReporitory;
        this.entidadeService = entidadeService;
    }

    public List<ComunicadoCadastroDTO> findAllComunicadoCadastroByComunicado(Optional<Long> entidadeParam, Optional<Long> exercicioParam, Long idComunicado) {
        Long entidade = entidadeParam.orElse(this.entidadeService.findEntidadePrincipal().getId());
        Long exercicio = exercicioParam.orElse(Long.valueOf(LocalDate.now().getYear()));
        return this.comunicadoCadastroReporitory.findAllByComunicado(entidade, exercicio, idComunicado);
    }
}

