/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class CadastroImobiliarioSituacaoService {
    public void setAtualSituacao(CadastroImobiliario imobiliario) {
        CadastroImobiliarioSituacao ultimaSituacao = this.getSituacaoUltimaSequencia(imobiliario.getSituacoes());
        if (Objects.isNull(ultimaSituacao) || !imobiliario.getSituacaoImobiliario().getId().equals(ultimaSituacao.getSituacaoImobiliario().getId())) {
            CadastroImobiliarioSituacao imobiliarioSituacao = new CadastroImobiliarioSituacao();
            imobiliarioSituacao.setSequencia(Long.valueOf(imobiliario.getUltimaSequenciaSituacao() + 1L));
            imobiliarioSituacao.setAtual(Boolean.valueOf(true));
            imobiliarioSituacao.setSituacaoImobiliario(imobiliario.getSituacaoImobiliario());
            imobiliario.getSituacoes().add(imobiliarioSituacao);
            this.setAtualFalseSituacoes(imobiliario.getSituacoes());
        }
    }

    private void setAtualFalseSituacoes(List<CadastroImobiliarioSituacao> situacoes) {
        CadastroImobiliarioSituacao ultimaSituacao = this.getSituacaoUltimaSequencia(situacoes);
        if (Objects.nonNull(ultimaSituacao)) {
            situacoes.stream().filter(situacao -> !ultimaSituacao.getSequencia().equals(situacao.getSequencia())).forEach(situacao -> situacao.setAtual(Boolean.valueOf(false)));
        }
    }

    private CadastroImobiliarioSituacao getSituacaoUltimaSequencia(List<CadastroImobiliarioSituacao> situacoes) {
        return situacoes.stream().filter(situacao -> situacao.getSequencia() != null).max(Comparator.comparingLong(CadastroImobiliarioSituacao::getSequencia)).orElse(null);
    }
}

