/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaResponseDTO;
import br.com.elotech.tributos.exception.AtualizacaoMonetariaException;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AtualizacaoMonetariaService
extends CrudService<AtualizacaoMonetaria, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoMonetariaService.class);
    private static final String URL_ATUALIZACAO_MONETARIA_AISE = "/datasnap/rest/tatualizacaomonetaria/GerarAtualizacao/";
    @Autowired
    private final AiseLoginServiceRest aiseLoginServiceRest;
    @Autowired
    private final RestTemplate restTemplate;
    @Autowired
    private final TributosProperties tributosProperties;

    public AtualizacaoMonetariaResponseDTO generateAtualizacaoMonetaria(AtualizacaoMonetariaDTO atualizacaoMonetariaDTO) {
        LoginRespostaRest loginResponse = this.aiseLoginServiceRest.login();
        HttpHeaders headers = this.createHeaders(loginResponse);
        try {
            return (AtualizacaoMonetariaResponseDTO)this.restTemplate.exchange(this.getUrlAtualizacaoMonetariaAise(), HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)atualizacaoMonetariaDTO, (HttpHeaders)headers), AtualizacaoMonetariaResponseDTO.class, new Object[0]).getBody();
        }
        catch (Exception ex) {
            log.error("{} - {}", new Object[]{"Erro ao gerar atualiza\u00e7\u00e3o monet\u00e1ria", ex.getMessage(), ex});
            throw new AtualizacaoMonetariaException(ex.getMessage());
        }
    }

    private HttpHeaders createHeaders(LoginRespostaRest loginResponse) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResponse.getIdToken());
        return headers;
    }

    private String getUrlAtualizacaoMonetariaAise() {
        return this.tributosProperties.getAise().getWsBaseUrl() + URL_ATUALIZACAO_MONETARIA_AISE;
    }

    @Generated
    public AtualizacaoMonetariaService(AiseLoginServiceRest aiseLoginServiceRest, RestTemplate restTemplate, TributosProperties tributosProperties) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
    }
}

