/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.AcertoPagamento;
import br.com.elotech.tributos.domain.AcertoPagamentoItem;
import br.com.elotech.tributos.domain.AcertoPagamentoItemId;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoBoleto;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.dto.pagamento.AcertoPagamentoNovoDTO;
import br.com.elotech.tributos.dto.pagamento.AcertoPagamentoResponseDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoItemSelecionadoDTO;
import br.com.elotech.tributos.repository.AcertoPagamentoRepository;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.EstornoPagamentoService;
import br.com.elotech.tributos.service.PagamentoLoteManualService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AcertoPagamentoService
extends CrudService<AcertoPagamento, Long> {
    private AcertoPagamentoRepository acertoPagamentoRepository;
    private ConvenioService convenioService;
    private PagamentoLoteService pagamentoLoteService;
    private BloquetoService boletoService;
    private PagamentoService pagamentoService;
    private PagamentoLoteManualService pagamentoLoteManualService;
    private DebitoParcelaService debitoParcelaService;
    private EstornoPagamentoService estornoPagamentoService;

    public AcertoPagamentoService(AcertoPagamentoRepository acertoPagamentoRepository, ConvenioService convenioService, PagamentoLoteService pagamentoLoteService, BloquetoService boletoService, PagamentoService pagamentoService, PagamentoLoteManualService pagamentoLoteManualService, DebitoParcelaService debitoParcelaService, EstornoPagamentoService estornoPagamentoService) {
        this.acertoPagamentoRepository = acertoPagamentoRepository;
        this.convenioService = convenioService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.boletoService = boletoService;
        this.pagamentoService = pagamentoService;
        this.pagamentoLoteManualService = pagamentoLoteManualService;
        this.debitoParcelaService = debitoParcelaService;
        this.estornoPagamentoService = estornoPagamentoService;
    }

    public AcertoPagamentoResponseDTO salvarAcertoPagamento(AcertoPagamentoNovoDTO novoPagamento) {
        if (novoPagamento.getBoletos().isEmpty()) {
            throw new EloValidationException("Acerto pagamento deve possuir pelo menos um boleto.");
        }
        List boletos = this.validaBoletos(novoPagamento);
        Pagamento pagamentoOrigem = this.findPagamentoOrigem(novoPagamento);
        PagamentoLote pagamentoLote = this.createPagamentoLote(novoPagamento);
        List pagamentosNovos = this.geraPagamentos(pagamentoLote, boletos);
        this.pagamentoLoteService.fecharLote(pagamentoLote);
        AcertoPagamento acertoPagamento = this.createAcertoPagamento(pagamentoOrigem, pagamentosNovos);
        return AcertoPagamentoResponseDTO.of((AcertoPagamento)acertoPagamento);
    }

    private AcertoPagamento createAcertoPagamento(Pagamento pagamentoOrigem, List<Pagamento> pagamentosNovos) {
        AtomicLong sequencia = new AtomicLong(1L);
        AcertoPagamento acertoPagamento = this.geraAcertoPagamento();
        pagamentosNovos.stream().map(pagamentoNovo -> {
            AcertoPagamentoItemId acertoPagamentoItemId = new AcertoPagamentoItemId();
            acertoPagamentoItemId.setAcertoPagamento(acertoPagamento);
            acertoPagamentoItemId.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
            AcertoPagamentoItem acertoPagamentoItem = new AcertoPagamentoItem();
            acertoPagamentoItem.setPagamentoOrigem(pagamentoOrigem);
            acertoPagamentoItem.setPagamentoNovo(pagamentoNovo);
            acertoPagamentoItem.setId(acertoPagamentoItemId);
            return acertoPagamentoItem;
        }).forEach(acertoPagamento.getAcertoPagamentoItemList()::add);
        this.acertoPagamentoRepository.save((Object)acertoPagamento);
        this.adicionarDescricaoNoAcerto(pagamentoOrigem.getId(), pagamentosNovos, acertoPagamento);
        List pagamentoDebitos = Optional.ofNullable(pagamentoOrigem.getPagamentoBoleto()).map(PagamentoBoleto::getPagamentosDebito).get();
        pagamentoDebitos.forEach(pagamentoDebito -> this.debitoParcelaService.addDescricaoDebitoParcelaPagamento(pagamentoDebito.getId().getDebitoParcelaTributo().getDebitoParcela(), acertoPagamento.getObservacao()));
        return (AcertoPagamento)this.acertoPagamentoRepository.save((Object)acertoPagamento);
    }

    private void adicionarDescricaoNoAcerto(PagamentoId pagamentoId, List<Pagamento> pagamentosNovos, AcertoPagamento acertoPagamento) {
        Bloqueto bloquetoDestino = ((Pagamento)pagamentosNovos.stream().findFirst().get()).getPagamentoBoleto().getBoleto();
        acertoPagamento.setObservacao(this.createDescricaoAcertoPagamento(pagamentoId, acertoPagamento, bloquetoDestino));
    }

    public String createDescricaoAcertoPagamento(PagamentoId pagamentoId, AcertoPagamento acertoPagamento, Bloqueto bloquetoDestino) {
        return String.format("Pagamento realizado pelo Acerto de Pagamento %d. Baixa do Pagamento %d/%d, pelo Boleto %d/%d. %s", acertoPagamento.getId(), pagamentoId.getPagamento(), pagamentoId.getExercicioPagamento(), bloquetoDestino.getBloqueto(), bloquetoDestino.getExercicioBloqueto(), acertoPagamento.getUsuario());
    }

    public AcertoPagamento geraAcertoPagamento() {
        AcertoPagamento acertoPagamento = new AcertoPagamento();
        acertoPagamento.setDataAcerto(LocalDateTime.now());
        acertoPagamento.setUsuario(UsuarioUtils.getUsuarioAise());
        return acertoPagamento;
    }

    private Pagamento findPagamentoOrigem(AcertoPagamentoNovoDTO novoPagamento) {
        return this.pagamentoService.findPagamentoById(novoPagamento.getEntidade(), novoPagamento.getExercicio(), novoPagamento.getPagamentoOrigem());
    }

    public List<Pagamento> geraPagamentos(PagamentoLote pagamentoLote, List<Bloqueto> boletos) {
        return this.pagamentoLoteManualService.geraPagamentos(pagamentoLote, boletos, Boolean.FALSE);
    }

    private List<Bloqueto> validaBoletos(AcertoPagamentoNovoDTO acertoPagamento) {
        return acertoPagamento.getBoletos().stream().map(boletoDTO -> {
            Bloqueto boleto = (Bloqueto)this.boletoService.findById((Serializable)boletoDTO.getId()).orElseThrow(() -> new EloValidationException("Boleto n\u00e3o encontrado."));
            if (boleto.getPago().booleanValue() || boleto.validaSeBoletoComParcelaPaga()) {
                throw new EloValidationException(String.format("Boleto %d/%d pago ou com parcelas pagas.", boleto.getBloqueto(), boleto.getExercicioBloqueto()));
            }
            return boleto;
        }).collect(Collectors.toList());
    }

    private PagamentoLote createPagamentoLote(AcertoPagamentoNovoDTO acertoPagamento) {
        Convenio convenio = (Convenio)this.convenioService.findById((Serializable)acertoPagamento.getConvenio()).orElseThrow(() -> new EloValidationException("Conv\u00eanio n\u00e3o encontrado."));
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(acertoPagamento.getEntidade());
        id.setExercicio(acertoPagamento.getExercicio());
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataMovimento(acertoPagamento.getDataMovimento().toLocalDate());
        pagamentoLote.setDataCredito(acertoPagamento.getDataCredito().toLocalDate());
        pagamentoLote.setDataLote(acertoPagamento.getDataLote().toLocalDate());
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.MANUAL);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    public AcertoPagamento estornoAcerto(Long id) {
        AcertoPagamento acertoPagamento = (AcertoPagamento)this.acertoPagamentoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Acerto de Pagamento %d n\u00e3o encontrado.", id)));
        if (Boolean.TRUE.equals(acertoPagamento.getEstornado())) {
            throw new EloValidationException("O acerto de pagamento j\u00e1 foi estornado.");
        }
        acertoPagamento.setEstornado(Boolean.TRUE);
        acertoPagamento.getAcertoPagamentoItemList().forEach(item -> {
            EstornoPagamentoDTO estornoPagamentoDTO = new EstornoPagamentoDTO();
            estornoPagamentoDTO.setTodosSelecionados(Boolean.FALSE);
            EstornoPagamentoItemSelecionadoDTO itemSelecionado = new EstornoPagamentoItemSelecionadoDTO();
            itemSelecionado.setExercicio(item.getPagamentoNovo().getId().getExercicioPagamento());
            itemSelecionado.setPagamento(item.getPagamentoNovo().getId().getPagamento());
            estornoPagamentoDTO.setSelecionados(estornoPagamentoDTO.getSelecionados());
            estornoPagamentoDTO.getSelecionados().add(itemSelecionado);
            estornoPagamentoDTO.setData(LocalDate.now());
            estornoPagamentoDTO.setMotivoEstorno(estornoPagamentoDTO.getMotivoEstorno());
            this.estornoPagamentoService.estornarPagamento(estornoPagamentoDTO);
        });
        return (AcertoPagamento)this.acertoPagamentoRepository.save((Object)acertoPagamento);
    }
}

