/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String USUARIO_CLAIM = "usuario_aise";

    public static UUID getUserId() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getSubject).map(UUID::fromString).orElse(null);
    }

    public static String getUserName() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(IDToken::getName).orElse("");
    }

    public static String getUserAise() {
        if (TenantContextHolder.hasTenant().booleanValue()) {
            return SecurityUtils.getToken().map(IDToken::getPreferredUsername).filter(userName -> userName.matches("^(\\d+)$")).orElse(null);
        }
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("usuario_aise")).map(Object::toString).orElse(null);
    }

    public static Optional<AccessToken> getToken() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken);
    }

    public static AccessToken getAccessToken() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel obter o access token do usu\u00e1rio na requisi\u00e7\u00e3o"));
    }

    public static String getRequestIP(RequestAttributes attributes) {
        ServletRequestAttributes servletRequestAttributes;
        String remoteAddr;
        if (Objects.nonNull(attributes) && StringUtils.isBlank((CharSequence)(remoteAddr = (servletRequestAttributes = (ServletRequestAttributes)attributes).getRequest().getHeader("X-FORWARDED-FOR")))) {
            return servletRequestAttributes.getRequest().getRemoteAddr();
        }
        return "";
    }

    public static String getRequestIP() {
        return SecurityUtils.getRequestIP((RequestAttributes)RequestContextHolder.getRequestAttributes());
    }

    public static KeycloakAuthenticationToken getAuthentication() {
        return (KeycloakAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
    }

    public static Optional<KeycloakSecurityContext> getSecurityContext() {
        Optional<KeycloakSecurityContext> requestSecurityContext = Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(requestAttributes -> (KeycloakSecurityContext)requestAttributes.getAttribute(KeycloakSecurityContext.class.getName(), 0));
        if (requestSecurityContext.isPresent()) {
            return requestSecurityContext;
        }
        return Optional.ofNullable(SecurityUtils.getAuthentication()).map(token -> token.getAccount().getKeycloakSecurityContext());
    }
}

