/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.core.crypto.EloCrypto;
import br.com.elotech.unico.client.AuthenticationClientUnicoFeign;
import br.com.elotech.unico.client.dto.LoginDTO;
import java.util.Objects;
import lombok.Generated;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.admin.client.Keycloak;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Profiles;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticationClientUnico {
    private static final String USUARIO_MASTER = "master";
    private final AuthenticationClientUnicoFeign authenticationClientUnicoFeign;
    private final Keycloak keycloak;
    private final ConfigurableEnvironment environment;

    public String authenticateAndReturnToken() {
        String token = this.authenticate();
        return "Bearer ".concat(token);
    }

    private String authenticate() {
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"cloud"}))) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            if (Objects.nonNull(securityContext) && Objects.nonNull(securityContext.getAuthentication()) && securityContext.getAuthentication() instanceof KeycloakAuthenticationToken) {
                KeycloakAuthenticationToken keycloakSecurityContext = (KeycloakAuthenticationToken)securityContext.getAuthentication();
                return keycloakSecurityContext.getAccount().getKeycloakSecurityContext().getTokenString();
            }
            return this.keycloak.tokenManager().grantToken().getToken();
        }
        LoginDTO loginDTO = LoginDTO.builder().username(USUARIO_MASTER).password(String.valueOf(EloCrypto.getNumeroDaSorte())).rememberMe(true).build();
        return this.authenticationClientUnicoFeign.authenticate(loginDTO).getToken();
    }

    @Generated
    public AuthenticationClientUnico(AuthenticationClientUnicoFeign authenticationClientUnicoFeign, Keycloak keycloak, ConfigurableEnvironment environment) {
        this.authenticationClientUnicoFeign = authenticationClientUnicoFeign;
        this.keycloak = keycloak;
        this.environment = environment;
    }
}

