/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.TipoSegmentoGeomaisDTO;
import br.com.elotech.tributos.service.TipoSegmentoService;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/tipo-segmento"})
public class TipoSegmentoGeomaisResource {
    private final TipoSegmentoService tipoSegmentoService;

    public TipoSegmentoGeomaisResource(TipoSegmentoService tipoSegmentoService) {
        this.tipoSegmentoService = tipoSegmentoService;
    }

    @GetMapping
    public ResponseEntity<Page<TipoSegmentoGeomaisDTO>> findAll(Pageable page) {
        Page segmentos = this.tipoSegmentoService.findAll(page).map(TipoSegmentoGeomaisDTO::from);
        return ResponseEntity.ok((Object)segmentos);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TipoSegmentoGeomaisDTO> findById(@PathVariable Long id) {
        TipoSegmentoGeomaisDTO tipoSegmentoGeomaisDTO = this.tipoSegmentoService.findById((Serializable)id).map(TipoSegmentoGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Tipo Segmento com o id '%d'.", id)));
        return ResponseEntity.ok((Object)tipoSegmentoGeomaisDTO);
    }
}

