/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.dto.integracaogeomais.ImobiliarioItbiGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.ProprietarioItbiGeomaisDTO;
import br.com.elotech.tributos.service.ImobiliarioItbiService;
import br.com.elotech.tributos.service.VinculoService;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/itbi"})
public class ImobiliarioItbiGeomaisResource {
    private final ImobiliarioItbiService imobiliarioItbiService;
    private final VinculoService vinculoService;

    public ImobiliarioItbiGeomaisResource(ImobiliarioItbiService imobiliarioItbiService, VinculoService vinculoService) {
        this.imobiliarioItbiService = imobiliarioItbiService;
        this.vinculoService = vinculoService;
    }

    @GetMapping
    public ResponseEntity<Page<ImobiliarioItbiGeomaisDTO>> findAll(Pageable page) {
        Page itbis = this.imobiliarioItbiService.findAll(page).map(arg_0 -> this.entityToGeomaisDTO(arg_0));
        return ResponseEntity.ok((Object)itbis);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ImobiliarioItbiGeomaisDTO> findById(@PathVariable Long id) {
        ImobiliarioItbiGeomaisDTO imobiliarioItbiGeomaisDTO = this.imobiliarioItbiService.findById((Serializable)id).map(arg_0 -> this.entityToGeomaisDTO(arg_0)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o ITBI com o id '%d'.", id)));
        return ResponseEntity.ok((Object)imobiliarioItbiGeomaisDTO);
    }

    private ImobiliarioItbiGeomaisDTO entityToGeomaisDTO(ImobiliarioItbi imobiliarioItbi) {
        ImobiliarioItbiGeomaisDTO imobiliario = ImobiliarioItbiGeomaisDTO.from((ImobiliarioItbi)imobiliarioItbi);
        imobiliarioItbi.getProprietarios().forEach(proprietarioItbi -> {
            Vinculo vinculo = (Vinculo)this.vinculoService.findOne((Serializable)proprietarioItbi.getVinculo());
            imobiliario.getProprietarios().add(ProprietarioItbiGeomaisDTO.from((ProprietarioItbi)proprietarioItbi, (Vinculo)vinculo));
        });
        return imobiliario;
    }
}

