/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento.cda;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.QuantidadeCpfCnpjInvalidosDTO;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import br.com.elotech.tributos.dto.documento.cda.LoteCdaResumoDTO;
import br.com.elotech.tributos.service.documento.cda.GeraLoteCertidaoDividaAtivaService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemPessoaService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lotes-cda"})
public class LoteCdaResource
extends CrudResource<LoteCda, Long> {
    private final LoteCdaService loteCdaService;
    private final GeraLoteCertidaoDividaAtivaService geraLoteCertidaoDividaAtivaService;
    private final LoteCdaItemPessoaService loteCdaItemPessoaService;

    public LoteCdaResource(LoteCdaService loteCdaService, GeraLoteCertidaoDividaAtivaService geraLoteCertidaoDividaAtivaService, LoteCdaItemPessoaService loteCdaItemPessoaService) {
        this.loteCdaService = loteCdaService;
        this.geraLoteCertidaoDividaAtivaService = geraLoteCertidaoDividaAtivaService;
        this.loteCdaItemPessoaService = loteCdaItemPessoaService;
    }

    @PostMapping(value={"/gerar-simulacao"})
    public ResponseEntity<LoteCdaResumoDTO> gerarSimulacao(@RequestBody @Valid GeracaoLoteCdaDTO geracaoDTO) {
        return ResponseEntity.ok((Object)this.loteCdaService.gerarSimulacao(geracaoDTO));
    }

    @PostMapping(value={"/{id}/gerar-certidoes"})
    public ResponseEntity<LoteCdaResumoDTO> gerarCertidoes(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.geraLoteCertidaoDividaAtivaService.gerarCertidoes(id));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<LoteCdaResumoDTO> getResumo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.loteCdaService.getResumo(id));
    }

    @GetMapping(value={"/{id}/itens"})
    public ResponseEntity<Page<LoteCdaItem>> searchItens(@PathVariable Long id, @RequestParam(required=false, defaultValue="") String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.loteCdaService.searchItens(id, search, pageable));
    }

    @PostMapping(value={"/{idLote}/revalidar-cpf-cnpj"})
    public ResponseEntity<QuantidadeCpfCnpjInvalidosDTO> revalidarCpfCnpj(@PathVariable Long idLote) {
        Long quantidadeInvalidos = this.loteCdaItemPessoaService.getQuantidadeInvalidosAndRevalidarCpfCnpjProprietarios(idLote);
        QuantidadeCpfCnpjInvalidosDTO quantidadeCpfCnpjInvalidosDTO = new QuantidadeCpfCnpjInvalidosDTO();
        quantidadeCpfCnpjInvalidosDTO.setQuantidadeInvalidos(quantidadeInvalidos);
        return ResponseEntity.ok((Object)quantidadeCpfCnpjInvalidosDTO);
    }
}

