/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.EstornoPagamento;
import br.com.elotech.tributos.domain.EstornoPagamentoId;
import br.com.elotech.tributos.dto.DetalheEstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.ReabilitacaoEstornoPagamentoDTO;
import br.com.elotech.tributos.service.EstornoPagamentoService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/estorno-pagamentos"})
public class EstornoPagamentoResource
extends ReadOnlyResource<EstornoPagamento, EstornoPagamentoId> {
    private final EstornoPagamentoService estornoPagamentoService;

    public EstornoPagamentoResource(EstornoPagamentoService estornoPagamentoService) {
        this.estornoPagamentoService = estornoPagamentoService;
    }

    @GetMapping(value={"/por-pagamento/{entidade}/{exercicioPagamento}/{pagamento}"})
    public ResponseEntity<List<DetalheEstornoPagamentoDTO>> getEstornoPagamentosById(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicioPagamento") Long exercicioPagamento, @PathVariable(value="pagamento") Long pagamento) {
        return ResponseEntity.ok((Object)this.estornoPagamentoService.getEstornoPagamentosById(entidade, exercicioPagamento, pagamento));
    }

    @PostMapping(value={"/estornar"})
    public ResponseEntity<Void> estornarPagamentos(@RequestBody EstornoPagamentoDTO estornoPagamentoDTO) {
        this.estornoPagamentoService.estornarPagamento(estornoPagamentoDTO);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/reabilitar"})
    public ResponseEntity<Void> reabilitarPagamento(EstornoPagamentoId estornoPagamentoId, @RequestBody ReabilitacaoEstornoPagamentoDTO reabilitacaoEstornoPagamentoDTO) {
        this.estornoPagamentoService.reabilitarEstorno(estornoPagamentoId, reabilitacaoEstornoPagamentoDTO);
        return ResponseEntity.noContent().build();
    }
}

