/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.DocumentoTipoUsuario;
import br.com.elotech.tributos.dto.DocumentoTipoUsuarioDTO;
import br.com.elotech.tributos.service.DocumentoTipoUsuarioService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documento-tipo-usuario"})
public class DocumentoTipoUsuarioResource {
    private final DocumentoTipoUsuarioService documentoTipoUsuarioService;

    public DocumentoTipoUsuarioResource(DocumentoTipoUsuarioService documentoTipoUsuarioService) {
        this.documentoTipoUsuarioService = documentoTipoUsuarioService;
    }

    @DeleteMapping(value={"{entidade}/{tipoDocumento}/{usuario}"})
    public ResponseEntity<Void> delete(@PathVariable Long entidade, @PathVariable Long tipoDocumento, @PathVariable String usuario) {
        this.documentoTipoUsuarioService.delete(entidade, tipoDocumento, usuario);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{tipoDocumento}/{usuario}"})
    public ResponseEntity<DocumentoTipoUsuario> create(@PathVariable Long tipoDocumento, @PathVariable String usuario) {
        return ResponseEntity.ok((Object)this.documentoTipoUsuarioService.create(tipoDocumento, usuario));
    }

    @PostMapping(value={"/copy/{usuarioASerCopiado}/{usuarioAReceber}"})
    public ResponseEntity<List<DocumentoTipoUsuario>> copy(@PathVariable String usuarioASerCopiado, @PathVariable String usuarioAReceber) {
        return ResponseEntity.ok((Object)this.documentoTipoUsuarioService.copy(usuarioASerCopiado, usuarioAReceber));
    }

    @GetMapping(value={"/{usuario}"})
    public ResponseEntity<List<DocumentoTipoUsuarioDTO>> getAllByEntidadeAndUsuario(@PathVariable String usuario) {
        return ResponseEntity.ok((Object)this.documentoTipoUsuarioService.getAllByUsuario(usuario));
    }

    @PostMapping(value={"/{usuario}/{tipoDocumento}/alterar"})
    public ResponseEntity<Void> toggleAlterar(@PathVariable String usuario, @PathVariable Long tipoDocumento) {
        this.documentoTipoUsuarioService.toggleAlterar(usuario, tipoDocumento);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{usuario}/{tipoDocumento}/inserir"})
    public ResponseEntity<Void> toggleInserir(@PathVariable String usuario, @PathVariable Long tipoDocumento) {
        this.documentoTipoUsuarioService.toggleInserir(usuario, tipoDocumento);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{usuario}/{tipoDocumento}/cancelar"})
    public ResponseEntity<Void> toggleCancelar(@PathVariable String usuario, @PathVariable Long tipoDocumento) {
        this.documentoTipoUsuarioService.toggleCancelar(usuario, tipoDocumento);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{usuario}/{tipoDocumento}/imprimir"})
    public ResponseEntity<Void> toggleImprimir(@PathVariable String usuario, @PathVariable Long tipoDocumento) {
        this.documentoTipoUsuarioService.toggleImprimir(usuario, tipoDocumento);
        return ResponseEntity.ok().build();
    }
}

