/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.imobiliario.DivisaoUnificacaoLote;
import br.com.elotech.tributos.dto.cadastroimobiliario.DesmembrarCadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.DivisaoUnificacaoLoteDTO;
import br.com.elotech.tributos.service.DivisaoUnificacaoLoteService;
import java.io.Serializable;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/divisao-unificacao-lote"})
public class DivisaoUnificacaoLoteResource
extends ReadOnlyResource<DivisaoUnificacaoLote, Long> {
    private final DivisaoUnificacaoLoteService divisaoUnificacaoLoteService;

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<DivisaoUnificacaoLoteDTO>> findAllListagem(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.getService().findByRsql(search, pageable);
        return ResponseEntity.ok((Object)result.map(DivisaoUnificacaoLoteDTO::from));
    }

    @GetMapping(value={"/dto/{id}"})
    public ResponseEntity<DivisaoUnificacaoLoteDTO> findById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)DivisaoUnificacaoLoteDTO.from((DivisaoUnificacaoLote)((DivisaoUnificacaoLote)this.getService().findOne((Serializable)id))));
    }

    @PostMapping(value={"/desmembrar"})
    public ResponseEntity<Long> desmembrar(@RequestBody DesmembrarCadastroImobiliarioDTO desmembramento) {
        return ResponseEntity.ok((Object)this.divisaoUnificacaoLoteService.desmembrar(desmembramento));
    }

    @Generated
    public DivisaoUnificacaoLoteResource(DivisaoUnificacaoLoteService divisaoUnificacaoLoteService) {
        this.divisaoUnificacaoLoteService = divisaoUnificacaoLoteService;
    }
}

