/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.service.DebitoCotaUnicaService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debitos-forma-pagamento"})
public class DebitoFormaPagamentoResource {
    private final DebitoCotaUnicaService debitoCotaUnicaService;

    public DebitoFormaPagamentoResource(DebitoCotaUnicaService debitoCotaUnicaService) {
        this.debitoCotaUnicaService = debitoCotaUnicaService;
    }

    @GetMapping(params={"tipo-cadastro", "cadastro-geral"})
    public ResponseEntity<List<DebitoAgrupadoPorFormaPagamentoDTO>> findAllCotaUnica(@RequestParam(value="tipo-cadastro") Long tipoCadastro, @RequestParam(value="cadastro-geral") Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.debitoCotaUnicaService.buscaDebitosAgrupadosPorFormaPagamentoDisponivelWeb(tipoCadastro, cadastroGeral));
    }

    @GetMapping(path={"/cota-unica"}, params={"tipo-cadastro", "cadastro-geral"})
    public ResponseEntity<Page<DebitoAgrupadoPorFormaPagamentoDTO>> findFirstCotaUnica(@RequestParam(value="tipo-cadastro") Long tipoCadastro, @RequestParam(value="cadastro-geral") Long cadastroGeral, Pageable pageable) {
        List allRecords = this.debitoCotaUnicaService.buscaPrimeiraCotaUnicaDisponivelWeb(tipoCadastro, cadastroGeral);
        List lista = allRecords.stream().skip(pageable.getOffset()).limit(pageable.getPageSize()).collect(Collectors.toList());
        return ResponseEntity.ok().body((Object)new PageImpl(lista, pageable, (long)allRecords.size()));
    }
}

