/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialAcrescimoDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDescontoDTO;
import br.com.elotech.tributos.service.BoletoEspecialCalculoService;
import br.com.elotech.tributos.service.BoletoEspecialService;
import br.com.elotech.tributos.service.GeraBoletoEspecialService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.rest.dto.BloquetoDTO;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/boletos-especial"})
public class BoletoEspecialResource {
    private final AisePdfService aisePdfService;
    private final GeraBoletoEspecialService geraBoletoEspecialService;
    private final BoletoEspecialCalculoService boletoEspecialCalculoService;
    private final BoletoEspecialService boletoEspecialService;

    public BoletoEspecialResource(AisePdfService aisePdfService, GeraBoletoEspecialService geraBoletoEspecialService, BoletoEspecialCalculoService boletoEspecialCalculoService, BoletoEspecialService boletoEspecialService) {
        this.geraBoletoEspecialService = geraBoletoEspecialService;
        this.aisePdfService = aisePdfService;
        this.boletoEspecialCalculoService = boletoEspecialCalculoService;
        this.boletoEspecialService = boletoEspecialService;
    }

    @PostMapping(value={"/inicial"})
    public ResponseEntity<BoletoEspecialDTO> gerarBoletoEspecialInicial(@RequestBody List<DebitoEmAbertoDTO> debitos) {
        return ResponseEntity.ok((Object)this.boletoEspecialService.getInitialValues(debitos));
    }

    @PostMapping(value={"/desconto"})
    public ResponseEntity<BoletoEspecialDTO> calcularDescontoBoletoEspecial(@RequestBody BoletoEspecialDescontoDTO desconto) {
        return ResponseEntity.ok((Object)this.boletoEspecialCalculoService.calcularDescontos(desconto));
    }

    @PostMapping(value={"/acrescimo"})
    public ResponseEntity<BoletoEspecialDTO> calcularAcrescimoBoletoEspecial(@RequestBody @Valid BoletoEspecialAcrescimoDTO acrescimo) {
        return ResponseEntity.ok((Object)this.boletoEspecialCalculoService.calcularAcrescimos(acrescimo));
    }

    @PostMapping
    public ResponseEntity<BloquetoDTO> gerarBoletoEspecial(@RequestBody @Valid BoletoEspecialDTO boletoEspecialDTO) {
        Bloqueto boleto = this.geraBoletoEspecialService.geraBoletoEspecial(boletoEspecialDTO);
        BloquetoDTO boletoDTO = BloquetoDTO.of((Bloqueto)boleto);
        boletoDTO.setUrlImpressao(this.aisePdfService.fetchBloquetoByExercicio(boletoDTO.getBloqueto(), boletoDTO.getExercicioBloqueto()));
        return ResponseEntity.ok((Object)boletoDTO);
    }
}

