/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.dto.AtualizaMotivoDeducaoDTO;
import br.com.elotech.tributos.dto.AtualizaNossoNumeroDTO;
import br.com.elotech.tributos.dto.pagamento.BaixaAutomaticaDetalheDTO;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteService;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/baixa-automatica-detalhes"})
public class BaixaAutomaticaDetalheResource {
    private final ProcessaPagamentoLoteService processaPagamentoLoteService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;

    public BaixaAutomaticaDetalheResource(ProcessaPagamentoLoteService processaPagamentoLoteService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService) {
        this.processaPagamentoLoteService = processaPagamentoLoteService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
    }

    @PutMapping(value={"/nossonumero"})
    public ResponseEntity<BaixaAutomaticaDetalheDTO> atualizarNossoNumero(@RequestBody @Valid AtualizaNossoNumeroDTO atualizaNossoNumero) {
        return ResponseEntity.ok((Object)this.processaPagamentoLoteService.atualizarNossoNumero(atualizaNossoNumero));
    }

    @PutMapping(value={"/conceder-desconto"})
    public ResponseEntity<BaixaAutomaticaDetalheDTO> concederDesconto(@RequestBody @Valid AtualizaMotivoDeducaoDTO atualizaMotivoDeducaoDTO) {
        return ResponseEntity.ok((Object)this.processaPagamentoLoteService.concederDesconto(atualizaMotivoDeducaoDTO));
    }

    @PutMapping(value={"/autorizar-pagamento-menor"})
    public ResponseEntity<BaixaAutomaticaDetalheDTO> autorizarPagamentoAMenor(@RequestBody @Valid BaixaAutomaticaDetalheId autorizaPagamentoAMenorDTO) {
        return ResponseEntity.ok((Object)this.processaPagamentoLoteService.autorizarPagamentoAMenor(autorizaPagamentoAMenorDTO));
    }

    @PutMapping(value={"/verificar-sequencia"})
    public ResponseEntity<BaixaAutomaticaDetalheDTO> verificarSequencia(@RequestBody @Valid BaixaAutomaticaDetalheId id) {
        return ResponseEntity.ok((Object)this.processaPagamentoLoteService.verificar(id));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<BaixaAutomaticaDetalheDTO>> findAllBaixaAutomaticaDetalhes(@RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.baixaAutomaticaDetalheService.findAllBaixaAutomaticaDetalhes(search, page));
    }

    @PutMapping(value={"/baixar-sequencia"})
    public ResponseEntity<BaixaAutomaticaDetalheDTO> baixarSequencia(@RequestBody @Valid BaixaAutomaticaDetalheId id) {
        return ResponseEntity.ok((Object)this.processaPagamentoLoteService.baixarSequencia(id));
    }
}

