/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipo;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoDetalheDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoFiltroDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoPorTipoResumoItemDTO;
import br.com.elotech.tributos.domain.integracaocontabil.ArrecadacaoResumoValoresDTO;
import java.util.HashMap;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ArrecadacaoRepository {
    private static final String COLUNAS_RESUMO_PAGAMENTO = "x.entidade,x.exercicioPagamento,x.pagamento";
    private static final String COLUNAS_RESUMO_CREDITO = "x.entidade,x.exercicioCredito,x.credito";
    private static final String RESUMO_ARRECADACAO_POR_PAGAMENTO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-resumo-arrecadacao-pagamento.sql";
    private static final String RESUMO_ARRECADACAO_POR_ESTORNO_PAGAMENTO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-resumo-arrecadacao-estorno-pagamento.sql";
    private static final String RESUMO_ARRECADACAO_POR_REABILITACAO_ESTORNO_PAGAMENTO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-resumo-arrecadacao-reabilitacao-estorno-pagamento.sql";
    private static final String RESUMO_ARRECADACAO_POR_CREDITO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-resumo-arrecadacao-credito.sql";
    private static final String RESUMO_ARRECADACAO_POR_ESTORNO_CREDITO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-resumo-arrecadacao-estorno-credito.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public ArrecadacaoRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private String getSelectSumFields(String colunas, String sql) {
        return String.format("SELECT %s\n       COALESCE(SUM(X.VALORPRINCIPAL),0) AS VALORPRINCIPAL,\n       COALESCE(SUM(X.VALORJUROS),0) AS VALORJUROS,\n       COALESCE(SUM(X.VALORMULTA),0) AS VALORMULTA,\n       COALESCE(SUM(X.VALORCORRECAO),0) AS VALORCORRECAO,\n       COALESCE(SUM(X.VALORDESCONTO),0) AS VALORDESCONTO,\n       COALESCE(SUM(X.VALORPRINCIPAL + X.VALORJUROS + X.VALORMULTA + X.VALORCORRECAO - X.VALORDESCONTO),0) AS VALORTOTAL\nFROM (\n%s\n) X\n", colunas, sql);
    }

    private ArrecadacaoPorTipoResumoItemDTO consultaResumoArrecadacaoPorTipo(ArrecadacaoPorTipo tipo, String sql, ArrecadacaoPorTipoFiltroDTO filtro) {
        ArrecadacaoPorTipoResumoItemDTO retorno = new ArrecadacaoPorTipoResumoItemDTO();
        retorno.setTipo(tipo);
        String finalSql = this.getSelectSumFields("", FileUtils.readResourceAsString((String)sql)).concat(filtro.buildFiltro());
        ArrecadacaoResumoValoresDTO valores = (ArrecadacaoResumoValoresDTO)this.jdbcTemplate.queryForObject(finalSql, new HashMap(), (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoResumoValoresDTO.class));
        retorno.setValores(valores);
        return retorno;
    }

    public ArrecadacaoPorTipoResumoItemDTO consultaResumoArrecadacaoPorPagamento(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaResumoArrecadacaoPorTipo(ArrecadacaoPorTipo.PAGAMENTOS, RESUMO_ARRECADACAO_POR_PAGAMENTO, filtro);
    }

    public ArrecadacaoPorTipoResumoItemDTO consultaResumoArrecadacaoPorEstornoPagamento(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaResumoArrecadacaoPorTipo(ArrecadacaoPorTipo.ESTORNO_PAGAMENTOS, RESUMO_ARRECADACAO_POR_ESTORNO_PAGAMENTO, filtro);
    }

    public ArrecadacaoPorTipoResumoItemDTO consultaResumoArrecadacaoPorReabilitacaoEstornoPagamento(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaResumoArrecadacaoPorTipo(ArrecadacaoPorTipo.REABILITACAO_ESTORNO_PAGAMENTOS, RESUMO_ARRECADACAO_POR_REABILITACAO_ESTORNO_PAGAMENTO, filtro);
    }

    public ArrecadacaoPorTipoResumoItemDTO consultaResumoArrecadacaoPorCreditos(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaResumoArrecadacaoPorTipo(ArrecadacaoPorTipo.CREDITOS, RESUMO_ARRECADACAO_POR_CREDITO, filtro);
    }

    public ArrecadacaoPorTipoResumoItemDTO consultaResumoArrecadacaoPorEstornoCreditos(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaResumoArrecadacaoPorTipo(ArrecadacaoPorTipo.ESTORNO_CREDITOS, RESUMO_ARRECADACAO_POR_ESTORNO_CREDITO, filtro);
    }

    private List<ArrecadacaoPorTipoDetalheDTO> consultaArrecadacaoPorTipoDetalhe(String colunas, String sql, ArrecadacaoPorTipoFiltroDTO filtro) {
        String finalSql = this.getSelectSumFields(colunas + ",", FileUtils.readResourceAsString((String)sql)).concat(filtro.buildFiltro()).concat("\ngroup by ").concat(colunas);
        return this.jdbcTemplate.query(finalSql, new HashMap(), (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoPorTipoDetalheDTO.class));
    }

    public List<ArrecadacaoPorTipoDetalheDTO> consultaArrecadacaoPorPagamentoDetalhe(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaArrecadacaoPorTipoDetalhe(COLUNAS_RESUMO_PAGAMENTO, RESUMO_ARRECADACAO_POR_PAGAMENTO, filtro);
    }

    public List<ArrecadacaoPorTipoDetalheDTO> consultaArrecadacaoPorEstornoPagamentoDetalhe(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaArrecadacaoPorTipoDetalhe(COLUNAS_RESUMO_PAGAMENTO, RESUMO_ARRECADACAO_POR_ESTORNO_PAGAMENTO, filtro);
    }

    public List<ArrecadacaoPorTipoDetalheDTO> consultaArrecadacaoPorReabilitacaoEstornoPagamentoDetalhe(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaArrecadacaoPorTipoDetalhe(COLUNAS_RESUMO_PAGAMENTO, RESUMO_ARRECADACAO_POR_REABILITACAO_ESTORNO_PAGAMENTO, filtro);
    }

    public List<ArrecadacaoPorTipoDetalheDTO> consultaArrecadacaoPorCreditoDetalhe(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaArrecadacaoPorTipoDetalhe(COLUNAS_RESUMO_CREDITO, RESUMO_ARRECADACAO_POR_CREDITO, filtro);
    }

    public List<ArrecadacaoPorTipoDetalheDTO> consultaArrecadacaoPorEstornoCreditoDetalhe(ArrecadacaoPorTipoFiltroDTO filtro) {
        return this.consultaArrecadacaoPorTipoDetalhe(COLUNAS_RESUMO_CREDITO, RESUMO_ARRECADACAO_POR_ESTORNO_CREDITO, filtro);
    }
}

