/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.FiltroArrecadacaoPorTributoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import java.sql.Date;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ArrecadacaoPorTributoRepository {
    private static final String DATA_LANCAMENTO = "dataLancamento";
    private static final String SQL_PAGAMENTOS = "br/com/elotech/tributos/repository/integracaocontabil/find-pagamentos-por-tributo.sql";
    private static final String SQL_ESTORNO_PAGAMENTOS = "br/com/elotech/tributos/repository/integracaocontabil/find-estorno-pagamentos-por-tributo.sql";
    private static final String SQL_CREDITOS = "br/com/elotech/tributos/repository/integracaocontabil/find-creditos-por-tributo.sql";
    private static final String SQL_ESTORNO_CREDITOS = "br/com/elotech/tributos/repository/integracaocontabil/find-estorno-creditos-por-tributo.sql";
    private static final String SQL_REABILITACAO_ESTORNO_PAGAMENTOS = "br/com/elotech/tributos/repository/integracaocontabil/find-reabilitacao-estorno-pagamentos-por-tributo.sql";
    private static final String SQL_DEVOLUCAO_CREDITOS = "br/com/elotech/tributos/repository/integracaocontabil/find-devolucao-creditos-por-tributo.sql";
    private static final String SQL_ESTORNO_DEVOLUCAO_CREDITO = "br/com/elotech/tributos/repository/integracaocontabil/find-estorno-devolucao-creditos-por-tributo.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public ArrecadacaoPorTributoRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<ArrecadacaoPorTributoValoresDTO> findPagamentosPorTributo(FiltroArrecadacaoPorTributoDTO filtro) {
        return this.queryArrecadacaoPorTributo(SQL_PAGAMENTOS, filtro);
    }

    public List<ArrecadacaoPorTributoValoresDTO> findEstornoPagamentosPorTributo(FiltroArrecadacaoPorTributoDTO filtro) {
        return this.queryArrecadacaoPorTributo(SQL_ESTORNO_PAGAMENTOS, filtro);
    }

    public List<ArrecadacaoPorTributoValoresDTO> findCreditosPorTributo(FiltroArrecadacaoPorTributoDTO filtro) {
        return this.queryArrecadacaoPorTributo(SQL_CREDITOS, filtro);
    }

    public List<ArrecadacaoPorTributoValoresDTO> findEstornoCreditosPorTributo(FiltroArrecadacaoPorTributoDTO filtro) {
        return this.queryArrecadacaoPorTributo(SQL_ESTORNO_CREDITOS, filtro);
    }

    public List<ArrecadacaoPorTributoValoresDTO> findReabilitacaoEstornoPagamentosPorTributo(FiltroArrecadacaoPorTributoDTO filtro) {
        return this.queryArrecadacaoPorTributo(SQL_REABILITACAO_ESTORNO_PAGAMENTOS, filtro);
    }

    public List<ArrecadacaoPorTributoValoresDTO> findDevolucaoCreditosPorTributo(FiltroArrecadacaoPorTributoDTO filtro) {
        return this.queryArrecadacaoPorTributo(SQL_DEVOLUCAO_CREDITOS, filtro);
    }

    public List<ArrecadacaoPorTributoValoresDTO> findEstornoDevolucaoCreditosPorTributo(FiltroArrecadacaoPorTributoDTO filtro) {
        return this.queryArrecadacaoPorTributo(SQL_ESTORNO_DEVOLUCAO_CREDITO, filtro);
    }

    private List<ArrecadacaoPorTributoValoresDTO> queryArrecadacaoPorTributo(String queryByTipo, FiltroArrecadacaoPorTributoDTO filtro) {
        String sql = String.format(FileUtils.readResourceAsString((String)queryByTipo), filtro.getWhereClausule());
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_LANCAMENTO, (Object)Date.valueOf(filtro.getDataLancamento()), 91);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoPorTributoValoresDTO.class));
    }
}

