/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.RecordNotFoundException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.dataset.Dataset;
import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.fluent.dataset.SimpleDataset;
import br.com.elotech.tributos.report.datasetrecord.CabecalhoDatasetRecord;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.RelatorioCustomRepository;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class RelatorioRepositoryImpl
implements RelatorioCustomRepository {
    private static final String CABECALHO = "sql/cabecalho.sql";
    protected static final String CABECALHO_NOT_FOUND = "Cabe\u00e7alho n\u00e3o encontrado";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;

    @Autowired
    public RelatorioRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate, EntidadeRepository entidadeRepository, ExercicioService exercicioService) {
        this.jdbcTemplate = jdbcTemplate;
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
    }

    public Dataset<CabecalhoDatasetRecord> getCabecalho() {
        String sql = FileUtils.readResourceAsString((String)CABECALHO);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("entidade", this.entidadeRepository.findByEntidadeprincipal().getId());
        map.put("exercicio", this.exercicioService.getExercicio());
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(CabecalhoDatasetRecord.class);
        List result = this.jdbcTemplate.query(sql, map, (RowMapper)rowMapper);
        return (Dataset)result.stream().findFirst().map(m -> SimpleDataset.single((DatasetRecord)m, CabecalhoDatasetRecord.class)).orElseThrow(() -> new RecordNotFoundException(CABECALHO_NOT_FOUND));
    }
}

