/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.dto.DebitoConstituidoItemDTO;
import br.com.elotech.tributos.dto.DebitoConsultaCancelamentoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaCreditoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaTributoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoDetalheParcelasDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelasConsultaDTO;
import br.com.elotech.tributos.dto.DebitoTributoConsultaDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.dto.documento.cda.DebitoGeracaoCdaDTO;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import br.com.elotech.tributos.repository.DebitoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DebitoRepositoryImpl
implements DebitoCustomRepository {
    private static final String ID = "id";
    private static final String ENTIDADE = "entidade";
    private static final String EXERCICIO = "exercicio";
    private static final String TIPOCADASTRO = "tipoCadastro";
    private static final String CADASTROGERAL = "cadastroGeral";
    private static final String DIVIDA = "divida";
    private static final String SUBDIVIDA = "subdivida";
    private static final String PARCELA = "parcela";
    private static final String SQL_EXISTS_DEBITO_ABERTO = "br/com/elotech/tributos/repository/mobile/existsDebitoEmAberto.sql";
    private static final String SQL_FIND_DEBITO = "br/com/elotech/tributos/repository/find-debito.sql";
    private static final String SQL_FIND_DEBITOS_PARCELAS = "br/com/elotech/tributos/repository/find-debito-parcelas.sql";
    private static final String SQL_FIND_PARCELA_DEBITOS = "br/com/elotech/tributos/repository/find-parcela-por-debitos.sql";
    private static final String SQL_FIND_DEBITOS_TRIBUTOS = "br/com/elotech/tributos/repository/find-debito-tributo.sql";
    private static final String SQL_FIND_DEBITO_CANCELAMENTO_PARCELA = "br/com/elotech/tributos/repository/find-debito-cancelamento-parcela.sql";
    private static final String SQL_FIND_CREDITOS = "br/com/elotech/tributos/repository/find-debito-creditos.sql";
    private static final String SQL_FIND_TRIBUTOS = "br/com/elotech/tributos/repository/find-debito-tributos-parcelas.sql";
    private static final String SQL_FIND_DEBITOS_GERACAO_CDA = "br/com/elotech/tributos/repository/find-debito-geracao-cda.sql";
    private static final String SQL_FIND_DEBITOS_ID_RELACIONADO_PAGAMENTO = "br/com/elotech/tributos/repository/find-debitos-id-relacionado-pagamento.sql";
    private static final String SQL_FIND_DEBITOS_CONSTITUIDOS = "br/com/elotech/tributos/repository/find-debito-constituido.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public DebitoRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public DebitoConsultaDTO findDebitoConsulta(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ID, (Object)id);
        return (DebitoConsultaDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConsultaDTO.class));
    }

    public DebitoDetalheParcelasDTO findDebitosParcelasByIdAndParcela(Long id, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_PARCELA_DEBITOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ID, (Object)id);
        params.addValue(PARCELA, (Object)parcela);
        return (DebitoDetalheParcelasDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoDetalheParcelasDTO.class));
    }

    public List<DebitoParcelasConsultaDTO> findDebitosParcelasConsulta(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_PARCELAS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ID, (Object)id);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelasConsultaDTO.class));
    }

    public List<DebitoTributoConsultaDTO> findDebitosTributosConsulta(Long id) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_TRIBUTOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ID, (Object)id);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoTributoConsultaDTO.class));
    }

    public List<DebitoConsultaCreditoPorParcelaDTO> findCreditosPorParcelas(Debito debito, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_CREDITOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ENTIDADE, (Object)debito.getEntidade());
        params.addValue(TIPOCADASTRO, (Object)debito.getTipoCadastro());
        params.addValue(CADASTROGERAL, (Object)debito.getCadastroGeralId());
        params.addValue(DIVIDA, (Object)debito.getGuiaRecolhimento());
        params.addValue(SUBDIVIDA, (Object)debito.getSubDivida());
        params.addValue(PARCELA, (Object)parcela);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConsultaCreditoPorParcelaDTO.class));
    }

    public List<DebitoConsultaTributoPorParcelaDTO> findTributosPorParcelas(Debito debito, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_TRIBUTOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(EXERCICIO, (Object)debito.getExercicio());
        params.addValue(ENTIDADE, (Object)debito.getEntidade());
        params.addValue(CADASTROGERAL, (Object)debito.getCadastroGeralId());
        params.addValue(TIPOCADASTRO, (Object)debito.getTipoCadastro());
        params.addValue(PARCELA, (Object)parcela);
        params.addValue(DIVIDA, (Object)debito.getGuiaRecolhimento());
        params.addValue(SUBDIVIDA, (Object)debito.getSubDivida());
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConsultaTributoPorParcelaDTO.class));
    }

    public Boolean possuiDebitosVencidos(String cpfCnpj) {
        String sql = FileUtils.readResourceAsString((String)SQL_EXISTS_DEBITO_ABERTO);
        MapSqlParameterSource params = new MapSqlParameterSource("cnpjCpf", (Object)cpfCnpj);
        params.addValue("dataBase", (Object)Date.valueOf(LocalDate.now()));
        List result = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (rs, rowNum) -> rs.getInt(1));
        return !result.isEmpty() && (Integer)result.get(0) > 0;
    }

    public List<Long> findPagos(@Param(value="ids") List<Long> ids) {
        String sql = "select td.iddebito      from tribdebito td     where td.iddebito in (:ids)       and not exists (select 1                         from tribdebitoparcela tdp                        inner join tribsituacaoparcela tsp      on tdp.situacaodebito = tsp.situacaoparcela                        inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                        where td.entidade = tdp.entidade                          and td.exercicio = tdp.exercicio                          and td.tipocadastro = tdp.tipocadastro                          and td.cadastrogeral = tdp.cadastrogeral                          and td.guiarecolhimento = tdp.guiarecolhimento                          and td.subdivida = tdp.subdivida                          and ttsp.tiposituacaoparcela <> 2)       and exists (select 1                         from tribdebitoparcela tdp                        inner join tribsituacaoparcela tsp      on tdp.situacaodebito = tsp.situacaoparcela                        inner join tribtiposituacaoparcela ttsp on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela                        where td.entidade = tdp.entidade                          and td.exercicio = tdp.exercicio                          and td.tipocadastro = tdp.tipocadastro                          and td.cadastrogeral = tdp.cadastrogeral                          and td.guiarecolhimento = tdp.guiarecolhimento                          and td.subdivida = tdp.subdivida                          and ttsp.tiposituacaoparcela = 2) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("ids", ids);
        return this.namedParameterJdbcTemplate.queryForList(sql, (SqlParameterSource)parameters, Long.class);
    }

    public List<DebitoDTO> findDebitoComParcelaEmAberto(@Param(value="idParcelamento") Long idParcelamento) {
        String sql = "select TribDebito.Entidade,           TribDebito.Exercicio,           TribDebito.TipoCadastro,           TribDebito.CadastroGeral,           TribDebito.GuiaRecolhimento,           TribDebito.SubDivida,           Count(dp.parcela) as NumeroParcelas      from Tribparcelamentodebitoorigem Tribparcelamentodebitoorigem      left outer join TribDebito TribDebito on TribDebito.Iddebito = Tribparcelamentodebitoorigem.Iddebitonovo      left outer join TribDebitoParcela dp on TribDebito.Entidade = dp.Entidade                                          and TribDebito.Exercicio = dp.Exercicio                                          and TribDebito.Tipocadastro = dp.Tipocadastro                                          and TribDebito.Cadastrogeral = dp.Cadastrogeral                                          and TribDebito.Guiarecolhimento = dp.Guiarecolhimento                                          and TribDebito.Subdivida = dp.Subdivida      left outer join tribSituacaoParcela tsp on dp.Situacaodebito = tsp.SituacaoParcela      left outer join tribTipoSituacaoParcela ttsp on tsp.Tiposituacaoparcela = ttsp.Tiposituacaoparcela     Where Tribparcelamentodebitoorigem.Idparcelamento = :idParcelamento       and ttsp.Tipo = 'A'     Group by TribDebito.Entidade,              TribDebito.Exercicio,              TribDebito.TipoCadastro,              TribDebito.CadastroGeral,              TribDebito.GuiaRecolhimento,              TribDebito.SubDivida     Order by TribDebito.Entidade,              TribDebito.Exercicio,              TribDebito.TipoCadastro,              TribDebito.CadastroGeral,              TribDebito.GuiaRecolhimento,              TribDebito.SubDivida ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idParcelamento", (Object)idParcelamento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (rs, rowNum) -> {
            DebitoDTO debitoDTO = new DebitoDTO();
            debitoDTO.setEntidade(Integer.valueOf(rs.getInt(ENTIDADE)));
            debitoDTO.setExercicio(Integer.valueOf(rs.getInt(EXERCICIO)));
            debitoDTO.setTipoCadastro(Integer.valueOf(rs.getInt("tipocadastro")));
            debitoDTO.setCadastroGeral(Integer.valueOf(rs.getInt("cadastrogeral")));
            debitoDTO.setGuiaRecolhimento(Integer.valueOf(rs.getInt("guiarecolhimento")));
            debitoDTO.setSubDivida(Integer.valueOf(rs.getInt(SUBDIVIDA)));
            debitoDTO.setNumeroParcelas(Integer.valueOf(rs.getInt("numeroparcelas")));
            return debitoDTO;
        });
    }

    public List<DebitoConsultaCancelamentoPorParcelaDTO> findCancelamentosPorParcela(Debito debito, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITO_CANCELAMENTO_PARCELA);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("Entidade", (Object)debito.getEntidade());
        params.addValue("Exercicio", (Object)debito.getExercicio());
        params.addValue("TipoCadastro", (Object)debito.getTipoCadastro());
        params.addValue("CadastroGeral", (Object)debito.getCadastroGeralId());
        params.addValue("GuiaRecolhimento", (Object)debito.getGuiaRecolhimento());
        params.addValue("SubDivida", (Object)debito.getSubDivida());
        params.addValue("Parcela", (Object)parcela);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConsultaCancelamentoPorParcelaDTO.class));
    }

    public List<DebitoGeracaoCdaDTO> findDebitosGeracaoCDA(GeracaoLoteCdaDTO geracaoLoteCdaDTO, Long entidade) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_GERACAO_CDA);
        MapSqlParameterSource params = this.getParameterSource(geracaoLoteCdaDTO, entidade);
        String finalSql = sql.replace("$[FILTROS]", geracaoLoteCdaDTO.filtro());
        return this.namedParameterJdbcTemplate.query(finalSql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoGeracaoCdaDTO.class));
    }

    private MapSqlParameterSource getParameterSource(GeracaoLoteCdaDTO geracaoLoteCdaDTO, Long entidade) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ENTIDADE, (Object)entidade);
        params.addValue(TIPOCADASTRO, (Object)geracaoLoteCdaDTO.getTipoCadastro().getValue());
        params.addValue("parcelado", (Object)geracaoLoteCdaDTO.getParcelado().getValue());
        params.addValue("reparcelado", (Object)geracaoLoteCdaDTO.getReparcelado().getValue());
        if (Objects.nonNull(geracaoLoteCdaDTO.getLivro())) {
            params.addValue("livro", (Object)geracaoLoteCdaDTO.getLivro().getLivro());
            params.addValue("exercicioLivro", (Object)geracaoLoteCdaDTO.getLivro().getExercicio());
        }
        if (Objects.nonNull(geracaoLoteCdaDTO.getPessoa())) {
            params.addValue("pessoa", (Object)geracaoLoteCdaDTO.getPessoa().getId());
        }
        if (Objects.nonNull(geracaoLoteCdaDTO.getVencimentoInicial())) {
            params.addValue("dataVencimentoInicial", (Object)Date.valueOf(geracaoLoteCdaDTO.getVencimentoInicial()));
        }
        if (Objects.nonNull(geracaoLoteCdaDTO.getVencimentoFinal())) {
            params.addValue("dataVencimentoFinal", (Object)Date.valueOf(geracaoLoteCdaDTO.getVencimentoFinal()));
        }
        if (Objects.nonNull(geracaoLoteCdaDTO.getVencimentoBaseInicial())) {
            params.addValue("dataVencimentoBaseInicial", (Object)Date.valueOf(geracaoLoteCdaDTO.getVencimentoBaseInicial()));
        }
        if (Objects.nonNull(geracaoLoteCdaDTO.getVencimentoBaseFinal())) {
            params.addValue("dataVencimentoBaseFinal", (Object)Date.valueOf(geracaoLoteCdaDTO.getVencimentoBaseFinal()));
        }
        return params;
    }

    public List<DebitoIdDTO> findDebitosIdRelacionadosPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        String sql = FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_ID_RELACIONADO_PAGAMENTO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ENTIDADE, (Object)entidade);
        params.addValue("exercicioPagamento", (Object)exercicioPagamento);
        params.addValue("pagamento", (Object)pagamento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoIdDTO.class));
    }

    public Long totalDebitosConstituidos(FiltroConsultaDebitoDTO filtro) {
        String queyCount = "SELECT COUNT(*) AS TOTAL ";
        String query = String.format(FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_CONSTITUIDOS), queyCount, "", filtro.generateWhere(), "");
        List total = this.namedParameterJdbcTemplate.query(query, (rs, rowNum) -> rs.getLong("TOTAL"));
        return total.stream().findFirst().orElse(0L);
    }

    public List<DebitoConstituidoItemDTO> findAllDebitosConstituidos(FiltroConsultaDebitoDTO filtro) {
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_CONSTITUIDOS), this.getSelectFields(), "", filtro.generateWhere(), this.getOrderByFields());
        return this.namedParameterJdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConstituidoItemDTO.class));
    }

    public List<DebitoConstituidoItemDTO> findAllDebitoConstituidoById(FiltroConsultaDebitoDTO filtro, Long idDebito) {
        String filtroIdDebito = String.format("AND TD.IDDEBITO = %d ", idDebito);
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_FIND_DEBITOS_CONSTITUIDOS), this.getSelectFields(), filtroIdDebito, filtro.generateWhere(), this.getOrderByFields());
        return this.namedParameterJdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoConstituidoItemDTO.class));
    }

    private String getSelectFields() {
        return "SELECT DISTINCT \nTD.IDDEBITO, \nTD.ENTIDADE, \nTD.EXERCICIO, \nTD.TIPOCADASTRO, \nTD.CADASTROGERAL, \nTCG.PESSOA, \nP.NOME AS NOMEPESSOA, \nTD.GUIARECOLHIMENTO AS DIVIDA, \nTD.SUBDIVIDA, \nTDP.PARCELA, \nTDPR.IDDEBITOPARCELARECEITA AS IDDEBITOTRIBUTO, \nTDPR.RECEITA AS TRIBUTO, \nRECEITA.TIPORECEITA AS TIPOTRIBUTO, \nRECEITATIPO.DESCRICAO AS TIPOTRIBUTODESCRICAO, \nTD.DATAPRIMEIRAPARCELA, \nTD.DATALANCAMENTO, \nTDP.DATAVENCIMENTO, \nTDP.SITUACAOLEGAL, \nTDPR.VALORORIGINAL, \nTDPR.VALOR, \n0 AS VALORJUROS, \n0 AS VALORMULTA, \n0 AS VALORCORRECAO, \nTD.FORMACORRECAO, \nCASE WHEN TD.PARCELADO = 'S' THEN 1 ELSE 0 END AS PARCELADO, \nCASE WHEN TD.REPARCELADO = 'S' THEN 1 ELSE 0 END AS REPARCELADO, \nTTSP.TIPOSITUACAOPARCELA, \nTSP.DESCRICAO AS SITUACAODEBITODESCRICAO, \nTSP.SIGLA AS SITUACAODEBITOSIGLA ";
    }

    private String getOrderByFields() {
        return "ORDER BY TD.ENTIDADE, \nTD.EXERCICIO, \nTD.TIPOCADASTRO, \nTD.CADASTROGERAL, \nTD.GUIARECOLHIMENTO, \nTD.SUBDIVIDA, \nTDP.PARCELA, \nTDPR.RECEITA";
    }
}

