/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.jpa.hibernate.HibernateUtils;
import br.com.elotech.core.jpa.support.DialectWrapper;
import br.com.elotech.core.jpa.support.JpaUtil;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.StatelessSession;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.SessionImpl;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SequenceGeneratorRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final EntityManager em;

    public SequenceGeneratorRepository(NamedParameterJdbcTemplate jdbcTemplate, EntityManager em) {
        this.jdbcTemplate = jdbcTemplate;
        this.em = em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextVal(String sequence) {
        SessionImpl session = (SessionImpl)this.em.unwrap(SessionImpl.class);
        Dialect dialect = HibernateUtils.getDialect((SessionImpl)session);
        if (!this.sequenceExists(dialect, sequence).booleanValue()) {
            DialectWrapper dialectWrapper = new DialectWrapper(dialect);
            String sqlCreateSequence = dialectWrapper.getCreateSequenceStrings(sequence, 2, 1);
            try (StatelessSession statelessSession = session.getFactory().openStatelessSession();){
                statelessSession.beginTransaction();
                statelessSession.createNativeQuery(sqlCreateSequence).executeUpdate();
                statelessSession.getTransaction().commit();
            }
            return 1L;
        }
        String sqlSequenceNextVal = dialect.getSelectSequenceNextValString(sequence);
        MapSqlParameterSource params = new MapSqlParameterSource();
        return (Long)this.jdbcTemplate.queryForObject("SELECT " + sqlSequenceNextVal + " FROM DUAL", (SqlParameterSource)params, Long.class);
    }

    private Boolean sequenceExists(Dialect dialect, String sequence) {
        String sqlSequenceQuery = JpaUtil.getQuerySequencesStringWithoutSchema((Dialect)dialect);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("sequence_name", (Object)sequence.toUpperCase());
        List sequencesName = this.jdbcTemplate.queryForList(sqlSequenceQuery, (SqlParameterSource)params, String.class);
        return !sequencesName.isEmpty();
    }
}

