/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.ComunicadoDTO;
import br.com.elotech.tributos.dto.SituacaoComunicado;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ComunicadoRepository {
    private static final String SQL_COMUNICADO = "br/com/elotech/tributos/repository/findComunicado.sql";
    private final JdbcTemplate jdbcTemplate;

    public ComunicadoRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<ComunicadoDTO> findAllByEntidadeAndExercicioAndDataValidade(Long entidade, Long exercicio, LocalDate dataValidade) {
        String sql = FileUtils.readResourceAsString((String)SQL_COMUNICADO) + " and (datavalidade is null or datavalidade >= ?) " + " and situacao <> 'C' ";
        return this.jdbcTemplate.query(sql, new Object[]{entidade, exercicio, Date.valueOf(dataValidade)}, (rs, rowNum) -> {
            ComunicadoDTO comunicado = new ComunicadoDTO();
            comunicado.setEntidade(Long.valueOf(rs.getLong("entidade")));
            comunicado.setExercicio(Long.valueOf(rs.getLong("exercicio")));
            comunicado.setIdComunicado(Long.valueOf(rs.getLong("idcomunicado")));
            comunicado.setDescricao(rs.getString("descricao"));
            Optional.ofNullable(rs.getDate("datavalidade")).map(Date::toLocalDate).ifPresent(arg_0 -> ((ComunicadoDTO)comunicado).setDataValidade(arg_0));
            comunicado.setSituacao(SituacaoComunicado.fromValue((String)rs.getString("situacao")));
            return comunicado;
        });
    }
}

