/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.ComunicadoCadastroDTO;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ComunicadoCadastroRepository {
    private static final String SQL_COMUNICADO_CADASTRO = "br/com/elotech/tributos/repository/findComunicadoCadastro.sql";
    private final JdbcTemplate jdbcTemplate;
    private static final Integer SITUACAO_CANCELADO = 5;

    public ComunicadoCadastroRepository(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<ComunicadoCadastroDTO> findAllByComunicado(Long entidade, Long exercicio, Long idComunicado) {
        String sql = FileUtils.readResourceAsString((String)SQL_COMUNICADO_CADASTRO) + String.format(" and (situacao is null or situacao <> %d) ", SITUACAO_CANCELADO);
        return this.jdbcTemplate.query(sql, new Object[]{entidade, exercicio, idComunicado}, (RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoCadastroDTO.class));
    }
}

